/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticbeanstalk.model.DeleteApplicationRequest;

public class DeleteApplicationRequestMarshaller
implements Marshaller<Request<DeleteApplicationRequest>, DeleteApplicationRequest> {
    public Request<DeleteApplicationRequest> marshall(DeleteApplicationRequest deleteApplicationRequest) {
        if (deleteApplicationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteApplicationRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "DeleteApplication");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteApplicationRequest.applicationName() != null) {
            request.addParameter("ApplicationName", StringUtils.fromString((String)deleteApplicationRequest.applicationName()));
        }
        if (deleteApplicationRequest.terminateEnvByForce() != null) {
            request.addParameter("TerminateEnvByForce", StringUtils.fromBoolean((Boolean)deleteApplicationRequest.terminateEnvByForce()));
        }
        return request;
    }
}

