/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticbeanstalk.model.BuildConfiguration;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreateApplicationVersionRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.S3Location;
import software.amazon.awssdk.services.elasticbeanstalk.model.SourceBuildInformation;

public class CreateApplicationVersionRequestMarshaller
implements Marshaller<Request<CreateApplicationVersionRequest>, CreateApplicationVersionRequest> {
    public Request<CreateApplicationVersionRequest> marshall(CreateApplicationVersionRequest createApplicationVersionRequest) {
        BuildConfiguration buildConfiguration;
        S3Location sourceBundle;
        SourceBuildInformation sourceBuildInformation;
        if (createApplicationVersionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createApplicationVersionRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "CreateApplicationVersion");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createApplicationVersionRequest.applicationName() != null) {
            request.addParameter("ApplicationName", StringUtils.fromString((String)createApplicationVersionRequest.applicationName()));
        }
        if (createApplicationVersionRequest.versionLabel() != null) {
            request.addParameter("VersionLabel", StringUtils.fromString((String)createApplicationVersionRequest.versionLabel()));
        }
        if (createApplicationVersionRequest.description() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createApplicationVersionRequest.description()));
        }
        if ((sourceBuildInformation = createApplicationVersionRequest.sourceBuildInformation()) != null) {
            if (sourceBuildInformation.sourceTypeString() != null) {
                request.addParameter("SourceBuildInformation.SourceType", StringUtils.fromString((String)sourceBuildInformation.sourceTypeString()));
            }
            if (sourceBuildInformation.sourceRepositoryString() != null) {
                request.addParameter("SourceBuildInformation.SourceRepository", StringUtils.fromString((String)sourceBuildInformation.sourceRepositoryString()));
            }
            if (sourceBuildInformation.sourceLocation() != null) {
                request.addParameter("SourceBuildInformation.SourceLocation", StringUtils.fromString((String)sourceBuildInformation.sourceLocation()));
            }
        }
        if ((sourceBundle = createApplicationVersionRequest.sourceBundle()) != null) {
            if (sourceBundle.s3Bucket() != null) {
                request.addParameter("SourceBundle.S3Bucket", StringUtils.fromString((String)sourceBundle.s3Bucket()));
            }
            if (sourceBundle.s3Key() != null) {
                request.addParameter("SourceBundle.S3Key", StringUtils.fromString((String)sourceBundle.s3Key()));
            }
        }
        if ((buildConfiguration = createApplicationVersionRequest.buildConfiguration()) != null) {
            if (buildConfiguration.artifactName() != null) {
                request.addParameter("BuildConfiguration.ArtifactName", StringUtils.fromString((String)buildConfiguration.artifactName()));
            }
            if (buildConfiguration.codeBuildServiceRole() != null) {
                request.addParameter("BuildConfiguration.CodeBuildServiceRole", StringUtils.fromString((String)buildConfiguration.codeBuildServiceRole()));
            }
            if (buildConfiguration.computeTypeString() != null) {
                request.addParameter("BuildConfiguration.ComputeType", StringUtils.fromString((String)buildConfiguration.computeTypeString()));
            }
            if (buildConfiguration.image() != null) {
                request.addParameter("BuildConfiguration.Image", StringUtils.fromString((String)buildConfiguration.image()));
            }
            if (buildConfiguration.timeoutInMinutes() != null) {
                request.addParameter("BuildConfiguration.TimeoutInMinutes", StringUtils.fromInteger((Integer)buildConfiguration.timeoutInMinutes()));
            }
        }
        if (createApplicationVersionRequest.autoCreateApplication() != null) {
            request.addParameter("AutoCreateApplication", StringUtils.fromBoolean((Boolean)createApplicationVersionRequest.autoCreateApplication()));
        }
        if (createApplicationVersionRequest.process() != null) {
            request.addParameter("Process", StringUtils.fromBoolean((Boolean)createApplicationVersionRequest.process()));
        }
        return request;
    }
}

