/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticbeanstalk.model.ApplyEnvironmentManagedActionRequest;

public class ApplyEnvironmentManagedActionRequestMarshaller
implements Marshaller<Request<ApplyEnvironmentManagedActionRequest>, ApplyEnvironmentManagedActionRequest> {
    public Request<ApplyEnvironmentManagedActionRequest> marshall(ApplyEnvironmentManagedActionRequest applyEnvironmentManagedActionRequest) {
        if (applyEnvironmentManagedActionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)applyEnvironmentManagedActionRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "ApplyEnvironmentManagedAction");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (applyEnvironmentManagedActionRequest.environmentName() != null) {
            request.addParameter("EnvironmentName", StringUtils.fromString((String)applyEnvironmentManagedActionRequest.environmentName()));
        }
        if (applyEnvironmentManagedActionRequest.environmentId() != null) {
            request.addParameter("EnvironmentId", StringUtils.fromString((String)applyEnvironmentManagedActionRequest.environmentId()));
        }
        if (applyEnvironmentManagedActionRequest.actionId() != null) {
            request.addParameter("ActionId", StringUtils.fromString((String)applyEnvironmentManagedActionRequest.actionId()));
        }
        return request;
    }
}

