/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateApplicationVersionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateApplicationVersionRequest> {
    private final String applicationName;
    private final String versionLabel;
    private final String description;

    private UpdateApplicationVersionRequest(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.versionLabel = builder.versionLabel;
        this.description = builder.description;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String versionLabel() {
        return this.versionLabel;
    }

    public String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.applicationName() == null ? 0 : this.applicationName().hashCode());
        hashCode = 31 * hashCode + (this.versionLabel() == null ? 0 : this.versionLabel().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApplicationVersionRequest)) {
            return false;
        }
        UpdateApplicationVersionRequest other = (UpdateApplicationVersionRequest)((Object)obj);
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.versionLabel() == null ^ this.versionLabel() == null) {
            return false;
        }
        if (other.versionLabel() != null && !other.versionLabel().equals(this.versionLabel())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        return other.description() == null || other.description().equals(this.description());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.applicationName() != null) {
            sb.append("ApplicationName: ").append(this.applicationName()).append(",");
        }
        if (this.versionLabel() != null) {
            sb.append("VersionLabel: ").append(this.versionLabel()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationName": {
                return Optional.of(clazz.cast(this.applicationName()));
            }
            case "VersionLabel": {
                return Optional.of(clazz.cast(this.versionLabel()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationName;
        private String versionLabel;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApplicationVersionRequest model) {
            this.applicationName(model.applicationName);
            this.versionLabel(model.versionLabel);
            this.description(model.description);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getVersionLabel() {
            return this.versionLabel;
        }

        @Override
        public final Builder versionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
            return this;
        }

        public final void setVersionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public UpdateApplicationVersionRequest build() {
            return new UpdateApplicationVersionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateApplicationVersionRequest> {
        public Builder applicationName(String var1);

        public Builder versionLabel(String var1);

        public Builder description(String var1);
    }
}

