/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.elasticbeanstalk.model.AvailableSolutionStackDetailsListCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.AvailableSolutionStackNamesListCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.SolutionStackDescription;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListAvailableSolutionStacksResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListAvailableSolutionStacksResponse> {
    private final List<String> solutionStacks;
    private final List<SolutionStackDescription> solutionStackDetails;

    private ListAvailableSolutionStacksResponse(BuilderImpl builder) {
        this.solutionStacks = builder.solutionStacks;
        this.solutionStackDetails = builder.solutionStackDetails;
    }

    public List<String> solutionStacks() {
        return this.solutionStacks;
    }

    public List<SolutionStackDescription> solutionStackDetails() {
        return this.solutionStackDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.solutionStacks() == null ? 0 : this.solutionStacks().hashCode());
        hashCode = 31 * hashCode + (this.solutionStackDetails() == null ? 0 : this.solutionStackDetails().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAvailableSolutionStacksResponse)) {
            return false;
        }
        ListAvailableSolutionStacksResponse other = (ListAvailableSolutionStacksResponse)((Object)obj);
        if (other.solutionStacks() == null ^ this.solutionStacks() == null) {
            return false;
        }
        if (other.solutionStacks() != null && !other.solutionStacks().equals(this.solutionStacks())) {
            return false;
        }
        if (other.solutionStackDetails() == null ^ this.solutionStackDetails() == null) {
            return false;
        }
        return other.solutionStackDetails() == null || other.solutionStackDetails().equals(this.solutionStackDetails());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.solutionStacks() != null) {
            sb.append("SolutionStacks: ").append(this.solutionStacks()).append(",");
        }
        if (this.solutionStackDetails() != null) {
            sb.append("SolutionStackDetails: ").append(this.solutionStackDetails()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SolutionStacks": {
                return Optional.of(clazz.cast(this.solutionStacks()));
            }
            case "SolutionStackDetails": {
                return Optional.of(clazz.cast(this.solutionStackDetails()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> solutionStacks;
        private List<SolutionStackDescription> solutionStackDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAvailableSolutionStacksResponse model) {
            this.solutionStacks(model.solutionStacks);
            this.solutionStackDetails(model.solutionStackDetails);
        }

        public final Collection<String> getSolutionStacks() {
            return this.solutionStacks;
        }

        @Override
        public final Builder solutionStacks(Collection<String> solutionStacks) {
            this.solutionStacks = AvailableSolutionStackNamesListCopier.copy(solutionStacks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder solutionStacks(String ... solutionStacks) {
            this.solutionStacks(Arrays.asList(solutionStacks));
            return this;
        }

        public final void setSolutionStacks(Collection<String> solutionStacks) {
            this.solutionStacks = AvailableSolutionStackNamesListCopier.copy(solutionStacks);
        }

        public final Collection<SolutionStackDescription.Builder> getSolutionStackDetails() {
            return this.solutionStackDetails != null ? (Collection)this.solutionStackDetails.stream().map(SolutionStackDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder solutionStackDetails(Collection<SolutionStackDescription> solutionStackDetails) {
            this.solutionStackDetails = AvailableSolutionStackDetailsListCopier.copy(solutionStackDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder solutionStackDetails(SolutionStackDescription ... solutionStackDetails) {
            this.solutionStackDetails(Arrays.asList(solutionStackDetails));
            return this;
        }

        public final void setSolutionStackDetails(Collection<SolutionStackDescription.BuilderImpl> solutionStackDetails) {
            this.solutionStackDetails = AvailableSolutionStackDetailsListCopier.copyFromBuilder(solutionStackDetails);
        }

        public ListAvailableSolutionStacksResponse build() {
            return new ListAvailableSolutionStacksResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListAvailableSolutionStacksResponse> {
        public Builder solutionStacks(Collection<String> var1);

        public Builder solutionStacks(String ... var1);

        public Builder solutionStackDetails(Collection<SolutionStackDescription> var1);

        public Builder solutionStackDetails(SolutionStackDescription ... var1);
    }
}

