/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.elasticbeanstalk.model.InstancesHealthAttribute;
import software.amazon.awssdk.services.elasticbeanstalk.model.InstancesHealthAttributesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeInstancesHealthRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeInstancesHealthRequest> {
    private final String environmentName;
    private final String environmentId;
    private final List<String> attributeNames;
    private final String nextToken;

    private DescribeInstancesHealthRequest(BuilderImpl builder) {
        this.environmentName = builder.environmentName;
        this.environmentId = builder.environmentId;
        this.attributeNames = builder.attributeNames;
        this.nextToken = builder.nextToken;
    }

    public String environmentName() {
        return this.environmentName;
    }

    public String environmentId() {
        return this.environmentId;
    }

    public List<InstancesHealthAttribute> attributeNames() {
        return TypeConverter.convert(this.attributeNames, InstancesHealthAttribute::fromValue);
    }

    public List<String> attributeNamesStrings() {
        return this.attributeNames;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.environmentName() == null ? 0 : this.environmentName().hashCode());
        hashCode = 31 * hashCode + (this.environmentId() == null ? 0 : this.environmentId().hashCode());
        hashCode = 31 * hashCode + (this.attributeNamesStrings() == null ? 0 : this.attributeNamesStrings().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstancesHealthRequest)) {
            return false;
        }
        DescribeInstancesHealthRequest other = (DescribeInstancesHealthRequest)((Object)obj);
        if (other.environmentName() == null ^ this.environmentName() == null) {
            return false;
        }
        if (other.environmentName() != null && !other.environmentName().equals(this.environmentName())) {
            return false;
        }
        if (other.environmentId() == null ^ this.environmentId() == null) {
            return false;
        }
        if (other.environmentId() != null && !other.environmentId().equals(this.environmentId())) {
            return false;
        }
        if (other.attributeNamesStrings() == null ^ this.attributeNamesStrings() == null) {
            return false;
        }
        if (other.attributeNamesStrings() != null && !other.attributeNamesStrings().equals(this.attributeNamesStrings())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.environmentName() != null) {
            sb.append("EnvironmentName: ").append(this.environmentName()).append(",");
        }
        if (this.environmentId() != null) {
            sb.append("EnvironmentId: ").append(this.environmentId()).append(",");
        }
        if (this.attributeNamesStrings() != null) {
            sb.append("AttributeNames: ").append(this.attributeNamesStrings()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EnvironmentName": {
                return Optional.of(clazz.cast(this.environmentName()));
            }
            case "EnvironmentId": {
                return Optional.of(clazz.cast(this.environmentId()));
            }
            case "AttributeNames": {
                return Optional.of(clazz.cast(this.attributeNamesStrings()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String environmentName;
        private String environmentId;
        private List<String> attributeNames;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstancesHealthRequest model) {
            this.environmentName(model.environmentName);
            this.environmentId(model.environmentId);
            this.attributeNames(model.attributeNames);
            this.nextToken(model.nextToken);
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        public final Collection<String> getAttributeNames() {
            return this.attributeNames;
        }

        @Override
        public final Builder attributeNames(Collection<String> attributeNames) {
            this.attributeNames = InstancesHealthAttributesCopier.copy(attributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeNames(String ... attributeNames) {
            this.attributeNames(Arrays.asList(attributeNames));
            return this;
        }

        public final void setAttributeNames(Collection<String> attributeNames) {
            this.attributeNames = InstancesHealthAttributesCopier.copy(attributeNames);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeInstancesHealthRequest build() {
            return new DescribeInstancesHealthRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeInstancesHealthRequest> {
        public Builder environmentName(String var1);

        public Builder environmentId(String var1);

        public Builder attributeNames(Collection<String> var1);

        public Builder attributeNames(String ... var1);

        public Builder nextToken(String var1);
    }
}

