/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentHealthAttribute;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentHealthAttributesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeEnvironmentHealthRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeEnvironmentHealthRequest> {
    private final String environmentName;
    private final String environmentId;
    private final List<String> attributeNames;

    private DescribeEnvironmentHealthRequest(BuilderImpl builder) {
        this.environmentName = builder.environmentName;
        this.environmentId = builder.environmentId;
        this.attributeNames = builder.attributeNames;
    }

    public String environmentName() {
        return this.environmentName;
    }

    public String environmentId() {
        return this.environmentId;
    }

    public List<EnvironmentHealthAttribute> attributeNames() {
        return TypeConverter.convert(this.attributeNames, EnvironmentHealthAttribute::fromValue);
    }

    public List<String> attributeNamesStrings() {
        return this.attributeNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.environmentName() == null ? 0 : this.environmentName().hashCode());
        hashCode = 31 * hashCode + (this.environmentId() == null ? 0 : this.environmentId().hashCode());
        hashCode = 31 * hashCode + (this.attributeNamesStrings() == null ? 0 : this.attributeNamesStrings().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEnvironmentHealthRequest)) {
            return false;
        }
        DescribeEnvironmentHealthRequest other = (DescribeEnvironmentHealthRequest)((Object)obj);
        if (other.environmentName() == null ^ this.environmentName() == null) {
            return false;
        }
        if (other.environmentName() != null && !other.environmentName().equals(this.environmentName())) {
            return false;
        }
        if (other.environmentId() == null ^ this.environmentId() == null) {
            return false;
        }
        if (other.environmentId() != null && !other.environmentId().equals(this.environmentId())) {
            return false;
        }
        if (other.attributeNamesStrings() == null ^ this.attributeNamesStrings() == null) {
            return false;
        }
        return other.attributeNamesStrings() == null || other.attributeNamesStrings().equals(this.attributeNamesStrings());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.environmentName() != null) {
            sb.append("EnvironmentName: ").append(this.environmentName()).append(",");
        }
        if (this.environmentId() != null) {
            sb.append("EnvironmentId: ").append(this.environmentId()).append(",");
        }
        if (this.attributeNamesStrings() != null) {
            sb.append("AttributeNames: ").append(this.attributeNamesStrings()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EnvironmentName": {
                return Optional.of(clazz.cast(this.environmentName()));
            }
            case "EnvironmentId": {
                return Optional.of(clazz.cast(this.environmentId()));
            }
            case "AttributeNames": {
                return Optional.of(clazz.cast(this.attributeNamesStrings()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String environmentName;
        private String environmentId;
        private List<String> attributeNames;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEnvironmentHealthRequest model) {
            this.environmentName(model.environmentName);
            this.environmentId(model.environmentId);
            this.attributeNames(model.attributeNames);
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        public final Collection<String> getAttributeNames() {
            return this.attributeNames;
        }

        @Override
        public final Builder attributeNames(Collection<String> attributeNames) {
            this.attributeNames = EnvironmentHealthAttributesCopier.copy(attributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeNames(String ... attributeNames) {
            this.attributeNames(Arrays.asList(attributeNames));
            return this;
        }

        public final void setAttributeNames(Collection<String> attributeNames) {
            this.attributeNames = EnvironmentHealthAttributesCopier.copy(attributeNames);
        }

        public DescribeEnvironmentHealthRequest build() {
            return new DescribeEnvironmentHealthRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeEnvironmentHealthRequest> {
        public Builder environmentName(String var1);

        public Builder environmentId(String var1);

        public Builder attributeNames(Collection<String> var1);

        public Builder attributeNames(String ... var1);
    }
}

