/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ConfigurationOptionSetting
implements ToCopyableBuilder<Builder, ConfigurationOptionSetting> {
    private final String resourceName;
    private final String namespace;
    private final String optionName;
    private final String value;

    private ConfigurationOptionSetting(BuilderImpl builder) {
        this.resourceName = builder.resourceName;
        this.namespace = builder.namespace;
        this.optionName = builder.optionName;
        this.value = builder.value;
    }

    public String resourceName() {
        return this.resourceName;
    }

    public String namespace() {
        return this.namespace;
    }

    public String optionName() {
        return this.optionName;
    }

    public String value() {
        return this.value;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.resourceName() == null ? 0 : this.resourceName().hashCode());
        hashCode = 31 * hashCode + (this.namespace() == null ? 0 : this.namespace().hashCode());
        hashCode = 31 * hashCode + (this.optionName() == null ? 0 : this.optionName().hashCode());
        hashCode = 31 * hashCode + (this.value() == null ? 0 : this.value().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationOptionSetting)) {
            return false;
        }
        ConfigurationOptionSetting other = (ConfigurationOptionSetting)obj;
        if (other.resourceName() == null ^ this.resourceName() == null) {
            return false;
        }
        if (other.resourceName() != null && !other.resourceName().equals(this.resourceName())) {
            return false;
        }
        if (other.namespace() == null ^ this.namespace() == null) {
            return false;
        }
        if (other.namespace() != null && !other.namespace().equals(this.namespace())) {
            return false;
        }
        if (other.optionName() == null ^ this.optionName() == null) {
            return false;
        }
        if (other.optionName() != null && !other.optionName().equals(this.optionName())) {
            return false;
        }
        if (other.value() == null ^ this.value() == null) {
            return false;
        }
        return other.value() == null || other.value().equals(this.value());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.resourceName() != null) {
            sb.append("ResourceName: ").append(this.resourceName()).append(",");
        }
        if (this.namespace() != null) {
            sb.append("Namespace: ").append(this.namespace()).append(",");
        }
        if (this.optionName() != null) {
            sb.append("OptionName: ").append(this.optionName()).append(",");
        }
        if (this.value() != null) {
            sb.append("Value: ").append(this.value()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceName": {
                return Optional.of(clazz.cast(this.resourceName()));
            }
            case "Namespace": {
                return Optional.of(clazz.cast(this.namespace()));
            }
            case "OptionName": {
                return Optional.of(clazz.cast(this.optionName()));
            }
            case "Value": {
                return Optional.of(clazz.cast(this.value()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceName;
        private String namespace;
        private String optionName;
        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationOptionSetting model) {
            this.resourceName(model.resourceName);
            this.namespace(model.namespace);
            this.optionName(model.optionName);
            this.value(model.value);
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public final String getOptionName() {
            return this.optionName;
        }

        @Override
        public final Builder optionName(String optionName) {
            this.optionName = optionName;
            return this;
        }

        public final void setOptionName(String optionName) {
            this.optionName = optionName;
        }

        public final String getValue() {
            return this.value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public ConfigurationOptionSetting build() {
            return new ConfigurationOptionSetting(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ConfigurationOptionSetting> {
        public Builder resourceName(String var1);

        public Builder namespace(String var1);

        public Builder optionName(String var1);

        public Builder value(String var1);
    }
}

