/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.model.AutoScalingGroup;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentResourceDescription;
import software.amazon.awssdk.services.elasticbeanstalk.model.Instance;
import software.amazon.awssdk.services.elasticbeanstalk.model.LaunchConfiguration;
import software.amazon.awssdk.services.elasticbeanstalk.model.LoadBalancer;
import software.amazon.awssdk.services.elasticbeanstalk.model.Queue;
import software.amazon.awssdk.services.elasticbeanstalk.model.Trigger;
import software.amazon.awssdk.services.elasticbeanstalk.transform.AutoScalingGroupUnmarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.InstanceUnmarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.LaunchConfigurationUnmarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.LoadBalancerUnmarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.QueueUnmarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.TriggerUnmarshaller;

public class EnvironmentResourceDescriptionUnmarshaller
implements Unmarshaller<EnvironmentResourceDescription, StaxUnmarshallerContext> {
    private static final EnvironmentResourceDescriptionUnmarshaller INSTANCE = new EnvironmentResourceDescriptionUnmarshaller();

    public EnvironmentResourceDescription unmarshall(StaxUnmarshallerContext context) throws Exception {
        EnvironmentResourceDescription.Builder environmentResourceDescription;
        block16: {
            environmentResourceDescription = EnvironmentResourceDescription.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<AutoScalingGroup> autoScalingGroups = null;
            ArrayList<Instance> instances = null;
            ArrayList<LaunchConfiguration> launchConfigurations = null;
            ArrayList<LoadBalancer> loadBalancers = null;
            ArrayList<Trigger> triggers = null;
            ArrayList<Queue> queues = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    environmentResourceDescription.autoScalingGroups(autoScalingGroups);
                    environmentResourceDescription.instances(instances);
                    environmentResourceDescription.launchConfigurations(launchConfigurations);
                    environmentResourceDescription.loadBalancers(loadBalancers);
                    environmentResourceDescription.triggers(triggers);
                    environmentResourceDescription.queues(queues);
                    break block16;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("EnvironmentName", targetDepth)) {
                        environmentResourceDescription.environmentName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("AutoScalingGroups", targetDepth)) {
                        autoScalingGroups = new ArrayList<AutoScalingGroup>();
                        continue;
                    }
                    if (context.testExpression("AutoScalingGroups/member", targetDepth)) {
                        autoScalingGroups.add(AutoScalingGroupUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Instances", targetDepth)) {
                        instances = new ArrayList<Instance>();
                        continue;
                    }
                    if (context.testExpression("Instances/member", targetDepth)) {
                        instances.add(InstanceUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("LaunchConfigurations", targetDepth)) {
                        launchConfigurations = new ArrayList<LaunchConfiguration>();
                        continue;
                    }
                    if (context.testExpression("LaunchConfigurations/member", targetDepth)) {
                        launchConfigurations.add(LaunchConfigurationUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("LoadBalancers", targetDepth)) {
                        loadBalancers = new ArrayList<LoadBalancer>();
                        continue;
                    }
                    if (context.testExpression("LoadBalancers/member", targetDepth)) {
                        loadBalancers.add(LoadBalancerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Triggers", targetDepth)) {
                        triggers = new ArrayList<Trigger>();
                        continue;
                    }
                    if (context.testExpression("Triggers/member", targetDepth)) {
                        triggers.add(TriggerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Queues", targetDepth)) {
                        queues = new ArrayList<Queue>();
                        continue;
                    }
                    if (!context.testExpression("Queues/member", targetDepth)) continue;
                    queues.add(QueueUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            environmentResourceDescription.autoScalingGroups(autoScalingGroups);
            environmentResourceDescription.instances(instances);
            environmentResourceDescription.launchConfigurations(launchConfigurations);
            environmentResourceDescription.loadBalancers(loadBalancers);
            environmentResourceDescription.triggers(triggers);
            environmentResourceDescription.queues(queues);
        }
        return (EnvironmentResourceDescription)environmentResourceDescription.build();
    }

    public static EnvironmentResourceDescriptionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

