/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.elasticbeanstalk.model.ComposeEnvironmentsRequest;
import software.amazon.awssdk.util.StringUtils;

public class ComposeEnvironmentsRequestMarshaller
implements Marshaller<Request<ComposeEnvironmentsRequest>, ComposeEnvironmentsRequest> {
    public Request<ComposeEnvironmentsRequest> marshall(ComposeEnvironmentsRequest composeEnvironmentsRequest) {
        List<String> versionLabelsList;
        if (composeEnvironmentsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)composeEnvironmentsRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "ComposeEnvironments");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (composeEnvironmentsRequest.applicationName() != null) {
            request.addParameter("ApplicationName", StringUtils.fromString((String)composeEnvironmentsRequest.applicationName()));
        }
        if (composeEnvironmentsRequest.groupName() != null) {
            request.addParameter("GroupName", StringUtils.fromString((String)composeEnvironmentsRequest.groupName()));
        }
        if ((versionLabelsList = composeEnvironmentsRequest.versionLabels()) != null) {
            if (!versionLabelsList.isEmpty()) {
                int versionLabelsListIndex = 1;
                for (String versionLabelsListValue : versionLabelsList) {
                    if (versionLabelsListValue != null) {
                        request.addParameter("VersionLabels.member." + versionLabelsListIndex, StringUtils.fromString((String)versionLabelsListValue));
                    }
                    ++versionLabelsListIndex;
                }
            } else {
                request.addParameter("VersionLabels", "");
            }
        }
        return request;
    }
}

