/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class MaxAgeRule
implements ToCopyableBuilder<Builder, MaxAgeRule> {
    private final Boolean enabled;
    private final Integer maxAgeInDays;
    private final Boolean deleteSourceFromS3;

    private MaxAgeRule(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.maxAgeInDays = builder.maxAgeInDays;
        this.deleteSourceFromS3 = builder.deleteSourceFromS3;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public Integer maxAgeInDays() {
        return this.maxAgeInDays;
    }

    public Boolean deleteSourceFromS3() {
        return this.deleteSourceFromS3;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.enabled() == null ? 0 : this.enabled().hashCode());
        hashCode = 31 * hashCode + (this.maxAgeInDays() == null ? 0 : this.maxAgeInDays().hashCode());
        hashCode = 31 * hashCode + (this.deleteSourceFromS3() == null ? 0 : this.deleteSourceFromS3().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaxAgeRule)) {
            return false;
        }
        MaxAgeRule other = (MaxAgeRule)obj;
        if (other.enabled() == null ^ this.enabled() == null) {
            return false;
        }
        if (other.enabled() != null && !other.enabled().equals(this.enabled())) {
            return false;
        }
        if (other.maxAgeInDays() == null ^ this.maxAgeInDays() == null) {
            return false;
        }
        if (other.maxAgeInDays() != null && !other.maxAgeInDays().equals(this.maxAgeInDays())) {
            return false;
        }
        if (other.deleteSourceFromS3() == null ^ this.deleteSourceFromS3() == null) {
            return false;
        }
        return other.deleteSourceFromS3() == null || other.deleteSourceFromS3().equals(this.deleteSourceFromS3());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.enabled() != null) {
            sb.append("Enabled: ").append(this.enabled()).append(",");
        }
        if (this.maxAgeInDays() != null) {
            sb.append("MaxAgeInDays: ").append(this.maxAgeInDays()).append(",");
        }
        if (this.deleteSourceFromS3() != null) {
            sb.append("DeleteSourceFromS3: ").append(this.deleteSourceFromS3()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private Integer maxAgeInDays;
        private Boolean deleteSourceFromS3;

        private BuilderImpl() {
        }

        private BuilderImpl(MaxAgeRule model) {
            this.setEnabled(model.enabled);
            this.setMaxAgeInDays(model.maxAgeInDays);
            this.setDeleteSourceFromS3(model.deleteSourceFromS3);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Integer getMaxAgeInDays() {
            return this.maxAgeInDays;
        }

        @Override
        public final Builder maxAgeInDays(Integer maxAgeInDays) {
            this.maxAgeInDays = maxAgeInDays;
            return this;
        }

        public final void setMaxAgeInDays(Integer maxAgeInDays) {
            this.maxAgeInDays = maxAgeInDays;
        }

        public final Boolean getDeleteSourceFromS3() {
            return this.deleteSourceFromS3;
        }

        @Override
        public final Builder deleteSourceFromS3(Boolean deleteSourceFromS3) {
            this.deleteSourceFromS3 = deleteSourceFromS3;
            return this;
        }

        public final void setDeleteSourceFromS3(Boolean deleteSourceFromS3) {
            this.deleteSourceFromS3 = deleteSourceFromS3;
        }

        public MaxAgeRule build() {
            return new MaxAgeRule(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MaxAgeRule> {
        public Builder enabled(Boolean var1);

        public Builder maxAgeInDays(Integer var1);

        public Builder deleteSourceFromS3(Boolean var1);
    }
}

