/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.elasticbeanstalk.model.EventDescription;
import software.amazon.awssdk.services.elasticbeanstalk.model.EventDescriptionListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeEventsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeEventsResponse> {
    private final List<EventDescription> events;
    private final String nextToken;

    private DescribeEventsResponse(BuilderImpl builder) {
        this.events = builder.events;
        this.nextToken = builder.nextToken;
    }

    public List<EventDescription> events() {
        return this.events;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.events() == null ? 0 : this.events().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventsResponse)) {
            return false;
        }
        DescribeEventsResponse other = (DescribeEventsResponse)((Object)obj);
        if (other.events() == null ^ this.events() == null) {
            return false;
        }
        if (other.events() != null && !other.events().equals(this.events())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.events() != null) {
            sb.append("Events: ").append(this.events()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<EventDescription> events;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventsResponse model) {
            this.setEvents(model.events);
            this.setNextToken(model.nextToken);
        }

        public final Collection<EventDescription> getEvents() {
            return this.events;
        }

        @Override
        public final Builder events(Collection<EventDescription> events) {
            this.events = EventDescriptionListCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(EventDescription ... events) {
            this.events(Arrays.asList(events));
            return this;
        }

        public final void setEvents(Collection<EventDescription> events) {
            this.events = EventDescriptionListCopier.copy(events);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeEventsResponse build() {
            return new DescribeEventsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeEventsResponse> {
        public Builder events(Collection<EventDescription> var1);

        public Builder events(EventDescription ... var1);

        public Builder nextToken(String var1);
    }
}

