/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationDescription;
import software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationDescriptionListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeApplicationsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeApplicationsResponse> {
    private final List<ApplicationDescription> applications;

    private DescribeApplicationsResponse(BuilderImpl builder) {
        this.applications = builder.applications;
    }

    public List<ApplicationDescription> applications() {
        return this.applications;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.applications() == null ? 0 : this.applications().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeApplicationsResponse)) {
            return false;
        }
        DescribeApplicationsResponse other = (DescribeApplicationsResponse)((Object)obj);
        if (other.applications() == null ^ this.applications() == null) {
            return false;
        }
        return other.applications() == null || other.applications().equals(this.applications());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.applications() != null) {
            sb.append("Applications: ").append(this.applications()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<ApplicationDescription> applications;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeApplicationsResponse model) {
            this.setApplications(model.applications);
        }

        public final Collection<ApplicationDescription> getApplications() {
            return this.applications;
        }

        @Override
        public final Builder applications(Collection<ApplicationDescription> applications) {
            this.applications = ApplicationDescriptionListCopier.copy(applications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applications(ApplicationDescription ... applications) {
            this.applications(Arrays.asList(applications));
            return this;
        }

        public final void setApplications(Collection<ApplicationDescription> applications) {
            this.applications = ApplicationDescriptionListCopier.copy(applications);
        }

        public DescribeApplicationsResponse build() {
            return new DescribeApplicationsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeApplicationsResponse> {
        public Builder applications(Collection<ApplicationDescription> var1);

        public Builder applications(ApplicationDescription ... var1);
    }
}

