/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionSetting;
import software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionSettingsListCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.SourceConfiguration;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateConfigurationTemplateRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateConfigurationTemplateRequest> {
    private final String applicationName;
    private final String templateName;
    private final String solutionStackName;
    private final String platformArn;
    private final SourceConfiguration sourceConfiguration;
    private final String environmentId;
    private final String description;
    private final List<ConfigurationOptionSetting> optionSettings;

    private CreateConfigurationTemplateRequest(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.templateName = builder.templateName;
        this.solutionStackName = builder.solutionStackName;
        this.platformArn = builder.platformArn;
        this.sourceConfiguration = builder.sourceConfiguration;
        this.environmentId = builder.environmentId;
        this.description = builder.description;
        this.optionSettings = builder.optionSettings;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String templateName() {
        return this.templateName;
    }

    public String solutionStackName() {
        return this.solutionStackName;
    }

    public String platformArn() {
        return this.platformArn;
    }

    public SourceConfiguration sourceConfiguration() {
        return this.sourceConfiguration;
    }

    public String environmentId() {
        return this.environmentId;
    }

    public String description() {
        return this.description;
    }

    public List<ConfigurationOptionSetting> optionSettings() {
        return this.optionSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.applicationName() == null ? 0 : this.applicationName().hashCode());
        hashCode = 31 * hashCode + (this.templateName() == null ? 0 : this.templateName().hashCode());
        hashCode = 31 * hashCode + (this.solutionStackName() == null ? 0 : this.solutionStackName().hashCode());
        hashCode = 31 * hashCode + (this.platformArn() == null ? 0 : this.platformArn().hashCode());
        hashCode = 31 * hashCode + (this.sourceConfiguration() == null ? 0 : this.sourceConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.environmentId() == null ? 0 : this.environmentId().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.optionSettings() == null ? 0 : this.optionSettings().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConfigurationTemplateRequest)) {
            return false;
        }
        CreateConfigurationTemplateRequest other = (CreateConfigurationTemplateRequest)((Object)obj);
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.templateName() == null ^ this.templateName() == null) {
            return false;
        }
        if (other.templateName() != null && !other.templateName().equals(this.templateName())) {
            return false;
        }
        if (other.solutionStackName() == null ^ this.solutionStackName() == null) {
            return false;
        }
        if (other.solutionStackName() != null && !other.solutionStackName().equals(this.solutionStackName())) {
            return false;
        }
        if (other.platformArn() == null ^ this.platformArn() == null) {
            return false;
        }
        if (other.platformArn() != null && !other.platformArn().equals(this.platformArn())) {
            return false;
        }
        if (other.sourceConfiguration() == null ^ this.sourceConfiguration() == null) {
            return false;
        }
        if (other.sourceConfiguration() != null && !other.sourceConfiguration().equals(this.sourceConfiguration())) {
            return false;
        }
        if (other.environmentId() == null ^ this.environmentId() == null) {
            return false;
        }
        if (other.environmentId() != null && !other.environmentId().equals(this.environmentId())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.optionSettings() == null ^ this.optionSettings() == null) {
            return false;
        }
        return other.optionSettings() == null || other.optionSettings().equals(this.optionSettings());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.applicationName() != null) {
            sb.append("ApplicationName: ").append(this.applicationName()).append(",");
        }
        if (this.templateName() != null) {
            sb.append("TemplateName: ").append(this.templateName()).append(",");
        }
        if (this.solutionStackName() != null) {
            sb.append("SolutionStackName: ").append(this.solutionStackName()).append(",");
        }
        if (this.platformArn() != null) {
            sb.append("PlatformArn: ").append(this.platformArn()).append(",");
        }
        if (this.sourceConfiguration() != null) {
            sb.append("SourceConfiguration: ").append(this.sourceConfiguration()).append(",");
        }
        if (this.environmentId() != null) {
            sb.append("EnvironmentId: ").append(this.environmentId()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.optionSettings() != null) {
            sb.append("OptionSettings: ").append(this.optionSettings()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String applicationName;
        private String templateName;
        private String solutionStackName;
        private String platformArn;
        private SourceConfiguration sourceConfiguration;
        private String environmentId;
        private String description;
        private List<ConfigurationOptionSetting> optionSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConfigurationTemplateRequest model) {
            this.setApplicationName(model.applicationName);
            this.setTemplateName(model.templateName);
            this.setSolutionStackName(model.solutionStackName);
            this.setPlatformArn(model.platformArn);
            this.setSourceConfiguration(model.sourceConfiguration);
            this.setEnvironmentId(model.environmentId);
            this.setDescription(model.description);
            this.setOptionSettings(model.optionSettings);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        public final String getSolutionStackName() {
            return this.solutionStackName;
        }

        @Override
        public final Builder solutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
            return this;
        }

        public final void setSolutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
        }

        public final String getPlatformArn() {
            return this.platformArn;
        }

        @Override
        public final Builder platformArn(String platformArn) {
            this.platformArn = platformArn;
            return this;
        }

        public final void setPlatformArn(String platformArn) {
            this.platformArn = platformArn;
        }

        public final SourceConfiguration getSourceConfiguration() {
            return this.sourceConfiguration;
        }

        @Override
        public final Builder sourceConfiguration(SourceConfiguration sourceConfiguration) {
            this.sourceConfiguration = sourceConfiguration;
            return this;
        }

        public final void setSourceConfiguration(SourceConfiguration sourceConfiguration) {
            this.sourceConfiguration = sourceConfiguration;
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<ConfigurationOptionSetting> getOptionSettings() {
            return this.optionSettings;
        }

        @Override
        public final Builder optionSettings(Collection<ConfigurationOptionSetting> optionSettings) {
            this.optionSettings = ConfigurationOptionSettingsListCopier.copy(optionSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionSettings(ConfigurationOptionSetting ... optionSettings) {
            this.optionSettings(Arrays.asList(optionSettings));
            return this;
        }

        public final void setOptionSettings(Collection<ConfigurationOptionSetting> optionSettings) {
            this.optionSettings = ConfigurationOptionSettingsListCopier.copy(optionSettings);
        }

        public CreateConfigurationTemplateRequest build() {
            return new CreateConfigurationTemplateRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateConfigurationTemplateRequest> {
        public Builder applicationName(String var1);

        public Builder templateName(String var1);

        public Builder solutionStackName(String var1);

        public Builder platformArn(String var1);

        public Builder sourceConfiguration(SourceConfiguration var1);

        public Builder environmentId(String var1);

        public Builder description(String var1);

        public Builder optionSettings(Collection<ConfigurationOptionSetting> var1);

        public Builder optionSettings(ConfigurationOptionSetting ... var1);
    }
}

