/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RebuildEnvironmentRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, RebuildEnvironmentRequest> {
    private final String environmentId;
    private final String environmentName;

    private RebuildEnvironmentRequest(BuilderImpl builder) {
        this.environmentId = builder.environmentId;
        this.environmentName = builder.environmentName;
    }

    public String environmentId() {
        return this.environmentId;
    }

    public String environmentName() {
        return this.environmentName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.environmentId() == null ? 0 : this.environmentId().hashCode());
        hashCode = 31 * hashCode + (this.environmentName() == null ? 0 : this.environmentName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RebuildEnvironmentRequest)) {
            return false;
        }
        RebuildEnvironmentRequest other = (RebuildEnvironmentRequest)((Object)obj);
        if (other.environmentId() == null ^ this.environmentId() == null) {
            return false;
        }
        if (other.environmentId() != null && !other.environmentId().equals(this.environmentId())) {
            return false;
        }
        if (other.environmentName() == null ^ this.environmentName() == null) {
            return false;
        }
        return other.environmentName() == null || other.environmentName().equals(this.environmentName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.environmentId() != null) {
            sb.append("EnvironmentId: ").append(this.environmentId()).append(",");
        }
        if (this.environmentName() != null) {
            sb.append("EnvironmentName: ").append(this.environmentName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String environmentId;
        private String environmentName;

        private BuilderImpl() {
        }

        private BuilderImpl(RebuildEnvironmentRequest model) {
            this.setEnvironmentId(model.environmentId);
            this.setEnvironmentName(model.environmentName);
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        public RebuildEnvironmentRequest build() {
            return new RebuildEnvironmentRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RebuildEnvironmentRequest> {
        public Builder environmentId(String var1);

        public Builder environmentName(String var1);
    }
}

