/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.elasticbeanstalk.model.PlatformBuilder;
import software.amazon.awssdk.services.elasticbeanstalk.model.PlatformSummary;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreatePlatformVersionResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, CreatePlatformVersionResponse> {
    private final PlatformSummary platformSummary;
    private final PlatformBuilder platformBuilder;

    private CreatePlatformVersionResponse(BuilderImpl builder) {
        this.platformSummary = builder.platformSummary;
        this.platformBuilder = builder.platformBuilder;
    }

    public PlatformSummary platformSummary() {
        return this.platformSummary;
    }

    public PlatformBuilder platformBuilder() {
        return this.platformBuilder;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.platformSummary() == null ? 0 : this.platformSummary().hashCode());
        hashCode = 31 * hashCode + (this.platformBuilder() == null ? 0 : this.platformBuilder().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePlatformVersionResponse)) {
            return false;
        }
        CreatePlatformVersionResponse other = (CreatePlatformVersionResponse)((Object)obj);
        if (other.platformSummary() == null ^ this.platformSummary() == null) {
            return false;
        }
        if (other.platformSummary() != null && !other.platformSummary().equals(this.platformSummary())) {
            return false;
        }
        if (other.platformBuilder() == null ^ this.platformBuilder() == null) {
            return false;
        }
        return other.platformBuilder() == null || other.platformBuilder().equals(this.platformBuilder());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.platformSummary() != null) {
            sb.append("PlatformSummary: ").append(this.platformSummary()).append(",");
        }
        if (this.platformBuilder() != null) {
            sb.append("PlatformBuilder: ").append(this.platformBuilder()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private PlatformSummary platformSummary;
        private PlatformBuilder platformBuilder;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePlatformVersionResponse model) {
            this.setPlatformSummary(model.platformSummary);
            this.setPlatformBuilder(model.platformBuilder);
        }

        public final PlatformSummary getPlatformSummary() {
            return this.platformSummary;
        }

        @Override
        public final Builder platformSummary(PlatformSummary platformSummary) {
            this.platformSummary = platformSummary;
            return this;
        }

        public final void setPlatformSummary(PlatformSummary platformSummary) {
            this.platformSummary = platformSummary;
        }

        public final PlatformBuilder getPlatformBuilder() {
            return this.platformBuilder;
        }

        @Override
        public final Builder platformBuilder(PlatformBuilder platformBuilder) {
            this.platformBuilder = platformBuilder;
            return this;
        }

        public final void setPlatformBuilder(PlatformBuilder platformBuilder) {
            this.platformBuilder = platformBuilder;
        }

        public CreatePlatformVersionResponse build() {
            return new CreatePlatformVersionResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreatePlatformVersionResponse> {
        public Builder platformSummary(PlatformSummary var1);

        public Builder platformBuilder(PlatformBuilder var1);
    }
}

