/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.elasticbeanstalk.model.SwapEnvironmentCNAMEsRequest;
import software.amazon.awssdk.util.StringUtils;

public class SwapEnvironmentCNAMEsRequestMarshaller
implements Marshaller<Request<SwapEnvironmentCNAMEsRequest>, SwapEnvironmentCNAMEsRequest> {
    public Request<SwapEnvironmentCNAMEsRequest> marshall(SwapEnvironmentCNAMEsRequest swapEnvironmentCNAMEsRequest) {
        if (swapEnvironmentCNAMEsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)swapEnvironmentCNAMEsRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "SwapEnvironmentCNAMEs");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (swapEnvironmentCNAMEsRequest.sourceEnvironmentId() != null) {
            request.addParameter("SourceEnvironmentId", StringUtils.fromString((String)swapEnvironmentCNAMEsRequest.sourceEnvironmentId()));
        }
        if (swapEnvironmentCNAMEsRequest.sourceEnvironmentName() != null) {
            request.addParameter("SourceEnvironmentName", StringUtils.fromString((String)swapEnvironmentCNAMEsRequest.sourceEnvironmentName()));
        }
        if (swapEnvironmentCNAMEsRequest.destinationEnvironmentId() != null) {
            request.addParameter("DestinationEnvironmentId", StringUtils.fromString((String)swapEnvironmentCNAMEsRequest.destinationEnvironmentId()));
        }
        if (swapEnvironmentCNAMEsRequest.destinationEnvironmentName() != null) {
            request.addParameter("DestinationEnvironmentName", StringUtils.fromString((String)swapEnvironmentCNAMEsRequest.destinationEnvironmentName()));
        }
        return request;
    }
}

