/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.elasticbeanstalk.model.Listener;
import software.amazon.awssdk.services.elasticbeanstalk.model.LoadBalancerListenersDescriptionCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LoadBalancerDescription
implements ToCopyableBuilder<Builder, LoadBalancerDescription> {
    private final String loadBalancerName;
    private final String domain;
    private final List<Listener> listeners;

    private LoadBalancerDescription(BuilderImpl builder) {
        this.loadBalancerName = builder.loadBalancerName;
        this.domain = builder.domain;
        this.listeners = builder.listeners;
    }

    public String loadBalancerName() {
        return this.loadBalancerName;
    }

    public String domain() {
        return this.domain;
    }

    public List<Listener> listeners() {
        return this.listeners;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.loadBalancerName() == null ? 0 : this.loadBalancerName().hashCode());
        hashCode = 31 * hashCode + (this.domain() == null ? 0 : this.domain().hashCode());
        hashCode = 31 * hashCode + (this.listeners() == null ? 0 : this.listeners().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadBalancerDescription)) {
            return false;
        }
        LoadBalancerDescription other = (LoadBalancerDescription)obj;
        if (other.loadBalancerName() == null ^ this.loadBalancerName() == null) {
            return false;
        }
        if (other.loadBalancerName() != null && !other.loadBalancerName().equals(this.loadBalancerName())) {
            return false;
        }
        if (other.domain() == null ^ this.domain() == null) {
            return false;
        }
        if (other.domain() != null && !other.domain().equals(this.domain())) {
            return false;
        }
        if (other.listeners() == null ^ this.listeners() == null) {
            return false;
        }
        return other.listeners() == null || other.listeners().equals(this.listeners());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.loadBalancerName() != null) {
            sb.append("LoadBalancerName: ").append(this.loadBalancerName()).append(",");
        }
        if (this.domain() != null) {
            sb.append("Domain: ").append(this.domain()).append(",");
        }
        if (this.listeners() != null) {
            sb.append("Listeners: ").append(this.listeners()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String loadBalancerName;
        private String domain;
        private List<Listener> listeners;

        private BuilderImpl() {
        }

        private BuilderImpl(LoadBalancerDescription model) {
            this.setLoadBalancerName(model.loadBalancerName);
            this.setDomain(model.domain);
            this.setListeners(model.listeners);
        }

        public final String getLoadBalancerName() {
            return this.loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        public final String getDomain() {
            return this.domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final Collection<Listener> getListeners() {
            return this.listeners;
        }

        @Override
        public final Builder listeners(Collection<Listener> listeners) {
            this.listeners = LoadBalancerListenersDescriptionCopier.copy(listeners);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listeners(Listener ... listeners) {
            this.listeners(Arrays.asList(listeners));
            return this;
        }

        public final void setListeners(Collection<Listener> listeners) {
            this.listeners = LoadBalancerListenersDescriptionCopier.copy(listeners);
        }

        @SafeVarargs
        public final void setListeners(Listener ... listeners) {
            this.listeners(Arrays.asList(listeners));
        }

        public LoadBalancerDescription build() {
            return new LoadBalancerDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LoadBalancerDescription> {
        public Builder loadBalancerName(String var1);

        public Builder domain(String var1);

        public Builder listeners(Collection<Listener> var1);

        public Builder listeners(Listener ... var1);
    }
}

