/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.time.Instant;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentInfoType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EnvironmentInfoDescription
implements ToCopyableBuilder<Builder, EnvironmentInfoDescription> {
    private final String infoType;
    private final String ec2InstanceId;
    private final Instant sampleTimestamp;
    private final String message;

    private EnvironmentInfoDescription(BuilderImpl builder) {
        this.infoType = builder.infoType;
        this.ec2InstanceId = builder.ec2InstanceId;
        this.sampleTimestamp = builder.sampleTimestamp;
        this.message = builder.message;
    }

    public String infoType() {
        return this.infoType;
    }

    public String ec2InstanceId() {
        return this.ec2InstanceId;
    }

    public Instant sampleTimestamp() {
        return this.sampleTimestamp;
    }

    public String message() {
        return this.message;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.infoType() == null ? 0 : this.infoType().hashCode());
        hashCode = 31 * hashCode + (this.ec2InstanceId() == null ? 0 : this.ec2InstanceId().hashCode());
        hashCode = 31 * hashCode + (this.sampleTimestamp() == null ? 0 : this.sampleTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.message() == null ? 0 : this.message().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentInfoDescription)) {
            return false;
        }
        EnvironmentInfoDescription other = (EnvironmentInfoDescription)obj;
        if (other.infoType() == null ^ this.infoType() == null) {
            return false;
        }
        if (other.infoType() != null && !other.infoType().equals(this.infoType())) {
            return false;
        }
        if (other.ec2InstanceId() == null ^ this.ec2InstanceId() == null) {
            return false;
        }
        if (other.ec2InstanceId() != null && !other.ec2InstanceId().equals(this.ec2InstanceId())) {
            return false;
        }
        if (other.sampleTimestamp() == null ^ this.sampleTimestamp() == null) {
            return false;
        }
        if (other.sampleTimestamp() != null && !other.sampleTimestamp().equals(this.sampleTimestamp())) {
            return false;
        }
        if (other.message() == null ^ this.message() == null) {
            return false;
        }
        return other.message() == null || other.message().equals(this.message());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.infoType() != null) {
            sb.append("InfoType: ").append(this.infoType()).append(",");
        }
        if (this.ec2InstanceId() != null) {
            sb.append("Ec2InstanceId: ").append(this.ec2InstanceId()).append(",");
        }
        if (this.sampleTimestamp() != null) {
            sb.append("SampleTimestamp: ").append(this.sampleTimestamp()).append(",");
        }
        if (this.message() != null) {
            sb.append("Message: ").append(this.message()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String infoType;
        private String ec2InstanceId;
        private Instant sampleTimestamp;
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentInfoDescription model) {
            this.setInfoType(model.infoType);
            this.setEc2InstanceId(model.ec2InstanceId);
            this.setSampleTimestamp(model.sampleTimestamp);
            this.setMessage(model.message);
        }

        public final String getInfoType() {
            return this.infoType;
        }

        @Override
        public final Builder infoType(String infoType) {
            this.infoType = infoType;
            return this;
        }

        @Override
        public final Builder infoType(EnvironmentInfoType infoType) {
            this.infoType(infoType.toString());
            return this;
        }

        public final void setInfoType(String infoType) {
            this.infoType = infoType;
        }

        public final void setInfoType(EnvironmentInfoType infoType) {
            this.infoType(infoType.toString());
        }

        public final String getEc2InstanceId() {
            return this.ec2InstanceId;
        }

        @Override
        public final Builder ec2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
            return this;
        }

        public final void setEc2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
        }

        public final Instant getSampleTimestamp() {
            return this.sampleTimestamp;
        }

        @Override
        public final Builder sampleTimestamp(Instant sampleTimestamp) {
            this.sampleTimestamp = sampleTimestamp;
            return this;
        }

        public final void setSampleTimestamp(Instant sampleTimestamp) {
            this.sampleTimestamp = sampleTimestamp;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public EnvironmentInfoDescription build() {
            return new EnvironmentInfoDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EnvironmentInfoDescription> {
        public Builder infoType(String var1);

        public Builder infoType(EnvironmentInfoType var1);

        public Builder ec2InstanceId(String var1);

        public Builder sampleTimestamp(Instant var1);

        public Builder message(String var1);
    }
}

