/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticbeanstalk.model.Tag;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateTagsForResourceRequest;

public class UpdateTagsForResourceRequestMarshaller
implements Marshaller<Request<UpdateTagsForResourceRequest>, UpdateTagsForResourceRequest> {
    public Request<UpdateTagsForResourceRequest> marshall(UpdateTagsForResourceRequest updateTagsForResourceRequest) {
        if (updateTagsForResourceRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)updateTagsForResourceRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "UpdateTagsForResource");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateTagsForResourceRequest.resourceArn() != null) {
            request.addParameter("ResourceArn", StringConversion.fromString((String)updateTagsForResourceRequest.resourceArn()));
        }
        if (updateTagsForResourceRequest.tagsToAdd().isEmpty() && !(updateTagsForResourceRequest.tagsToAdd() instanceof SdkAutoConstructList)) {
            request.addParameter("TagsToAdd", "");
        } else if (!updateTagsForResourceRequest.tagsToAdd().isEmpty() && !(updateTagsForResourceRequest.tagsToAdd() instanceof SdkAutoConstructList)) {
            List<Tag> tagsToAddList = updateTagsForResourceRequest.tagsToAdd();
            int tagsToAddListIndex = 1;
            for (Tag tagsToAddListValue : tagsToAddList) {
                if (tagsToAddListValue.key() != null) {
                    request.addParameter("TagsToAdd.member." + tagsToAddListIndex + ".Key", StringConversion.fromString((String)tagsToAddListValue.key()));
                }
                if (tagsToAddListValue.value() != null) {
                    request.addParameter("TagsToAdd.member." + tagsToAddListIndex + ".Value", StringConversion.fromString((String)tagsToAddListValue.value()));
                }
                ++tagsToAddListIndex;
            }
        }
        if (updateTagsForResourceRequest.tagsToRemove().isEmpty() && !(updateTagsForResourceRequest.tagsToRemove() instanceof SdkAutoConstructList)) {
            request.addParameter("TagsToRemove", "");
        } else if (!updateTagsForResourceRequest.tagsToRemove().isEmpty() && !(updateTagsForResourceRequest.tagsToRemove() instanceof SdkAutoConstructList)) {
            List<String> tagsToRemoveList = updateTagsForResourceRequest.tagsToRemove();
            int tagsToRemoveListIndex = 1;
            for (String tagsToRemoveListValue : tagsToRemoveList) {
                if (tagsToRemoveListValue != null) {
                    request.addParameter("TagsToRemove.member." + tagsToRemoveListIndex, StringConversion.fromString((String)tagsToRemoveListValue));
                }
                ++tagsToRemoveListIndex;
            }
        }
        return request;
    }
}

