/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticbeanstalk.model.RetrieveEnvironmentInfoRequest;

public class RetrieveEnvironmentInfoRequestMarshaller
implements Marshaller<Request<RetrieveEnvironmentInfoRequest>, RetrieveEnvironmentInfoRequest> {
    public Request<RetrieveEnvironmentInfoRequest> marshall(RetrieveEnvironmentInfoRequest retrieveEnvironmentInfoRequest) {
        if (retrieveEnvironmentInfoRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)retrieveEnvironmentInfoRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "RetrieveEnvironmentInfo");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (retrieveEnvironmentInfoRequest.environmentId() != null) {
            request.addParameter("EnvironmentId", StringConversion.fromString((String)retrieveEnvironmentInfoRequest.environmentId()));
        }
        if (retrieveEnvironmentInfoRequest.environmentName() != null) {
            request.addParameter("EnvironmentName", StringConversion.fromString((String)retrieveEnvironmentInfoRequest.environmentName()));
        }
        if (retrieveEnvironmentInfoRequest.infoTypeAsString() != null) {
            request.addParameter("InfoType", StringConversion.fromString((String)retrieveEnvironmentInfoRequest.infoTypeAsString()));
        }
        return request;
    }
}

