/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribePlatformVersionRequest;

public class DescribePlatformVersionRequestMarshaller
implements Marshaller<Request<DescribePlatformVersionRequest>, DescribePlatformVersionRequest> {
    public Request<DescribePlatformVersionRequest> marshall(DescribePlatformVersionRequest describePlatformVersionRequest) {
        if (describePlatformVersionRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describePlatformVersionRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "DescribePlatformVersion");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describePlatformVersionRequest.platformArn() != null) {
            request.addParameter("PlatformArn", StringConversion.fromString((String)describePlatformVersionRequest.platformArn()));
        }
        return request;
    }
}

