/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import java.time.Instant;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEventsRequest;

public class DescribeEventsRequestMarshaller
implements Marshaller<Request<DescribeEventsRequest>, DescribeEventsRequest> {
    public Request<DescribeEventsRequest> marshall(DescribeEventsRequest describeEventsRequest) {
        if (describeEventsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeEventsRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "DescribeEvents");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeEventsRequest.applicationName() != null) {
            request.addParameter("ApplicationName", StringConversion.fromString((String)describeEventsRequest.applicationName()));
        }
        if (describeEventsRequest.versionLabel() != null) {
            request.addParameter("VersionLabel", StringConversion.fromString((String)describeEventsRequest.versionLabel()));
        }
        if (describeEventsRequest.templateName() != null) {
            request.addParameter("TemplateName", StringConversion.fromString((String)describeEventsRequest.templateName()));
        }
        if (describeEventsRequest.environmentId() != null) {
            request.addParameter("EnvironmentId", StringConversion.fromString((String)describeEventsRequest.environmentId()));
        }
        if (describeEventsRequest.environmentName() != null) {
            request.addParameter("EnvironmentName", StringConversion.fromString((String)describeEventsRequest.environmentName()));
        }
        if (describeEventsRequest.platformArn() != null) {
            request.addParameter("PlatformArn", StringConversion.fromString((String)describeEventsRequest.platformArn()));
        }
        if (describeEventsRequest.requestId() != null) {
            request.addParameter("RequestId", StringConversion.fromString((String)describeEventsRequest.requestId()));
        }
        if (describeEventsRequest.severityAsString() != null) {
            request.addParameter("Severity", StringConversion.fromString((String)describeEventsRequest.severityAsString()));
        }
        if (describeEventsRequest.startTime() != null) {
            request.addParameter("StartTime", StringConversion.fromInstant((Instant)describeEventsRequest.startTime()));
        }
        if (describeEventsRequest.endTime() != null) {
            request.addParameter("EndTime", StringConversion.fromInstant((Instant)describeEventsRequest.endTime()));
        }
        if (describeEventsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringConversion.fromInteger((Integer)describeEventsRequest.maxRecords()));
        }
        if (describeEventsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)describeEventsRequest.nextToken()));
        }
        return request;
    }
}

