/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeConfigurationOptionsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.OptionSpecification;

public class DescribeConfigurationOptionsRequestMarshaller
implements Marshaller<Request<DescribeConfigurationOptionsRequest>, DescribeConfigurationOptionsRequest> {
    public Request<DescribeConfigurationOptionsRequest> marshall(DescribeConfigurationOptionsRequest describeConfigurationOptionsRequest) {
        if (describeConfigurationOptionsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeConfigurationOptionsRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "DescribeConfigurationOptions");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeConfigurationOptionsRequest.applicationName() != null) {
            request.addParameter("ApplicationName", StringConversion.fromString((String)describeConfigurationOptionsRequest.applicationName()));
        }
        if (describeConfigurationOptionsRequest.templateName() != null) {
            request.addParameter("TemplateName", StringConversion.fromString((String)describeConfigurationOptionsRequest.templateName()));
        }
        if (describeConfigurationOptionsRequest.environmentName() != null) {
            request.addParameter("EnvironmentName", StringConversion.fromString((String)describeConfigurationOptionsRequest.environmentName()));
        }
        if (describeConfigurationOptionsRequest.solutionStackName() != null) {
            request.addParameter("SolutionStackName", StringConversion.fromString((String)describeConfigurationOptionsRequest.solutionStackName()));
        }
        if (describeConfigurationOptionsRequest.platformArn() != null) {
            request.addParameter("PlatformArn", StringConversion.fromString((String)describeConfigurationOptionsRequest.platformArn()));
        }
        if (describeConfigurationOptionsRequest.options().isEmpty() && !(describeConfigurationOptionsRequest.options() instanceof SdkAutoConstructList)) {
            request.addParameter("Options", "");
        } else if (!describeConfigurationOptionsRequest.options().isEmpty() && !(describeConfigurationOptionsRequest.options() instanceof SdkAutoConstructList)) {
            List<OptionSpecification> optionsList = describeConfigurationOptionsRequest.options();
            int optionsListIndex = 1;
            for (OptionSpecification optionsListValue : optionsList) {
                if (optionsListValue.resourceName() != null) {
                    request.addParameter("Options.member." + optionsListIndex + ".ResourceName", StringConversion.fromString((String)optionsListValue.resourceName()));
                }
                if (optionsListValue.namespace() != null) {
                    request.addParameter("Options.member." + optionsListIndex + ".Namespace", StringConversion.fromString((String)optionsListValue.namespace()));
                }
                if (optionsListValue.optionName() != null) {
                    request.addParameter("Options.member." + optionsListIndex + ".OptionName", StringConversion.fromString((String)optionsListValue.optionName()));
                }
                ++optionsListIndex;
            }
        }
        return request;
    }
}

