/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeApplicationVersionsRequest;

public class DescribeApplicationVersionsRequestMarshaller
implements Marshaller<Request<DescribeApplicationVersionsRequest>, DescribeApplicationVersionsRequest> {
    public Request<DescribeApplicationVersionsRequest> marshall(DescribeApplicationVersionsRequest describeApplicationVersionsRequest) {
        if (describeApplicationVersionsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeApplicationVersionsRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "DescribeApplicationVersions");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeApplicationVersionsRequest.applicationName() != null) {
            request.addParameter("ApplicationName", StringConversion.fromString((String)describeApplicationVersionsRequest.applicationName()));
        }
        if (describeApplicationVersionsRequest.versionLabels().isEmpty() && !(describeApplicationVersionsRequest.versionLabels() instanceof SdkAutoConstructList)) {
            request.addParameter("VersionLabels", "");
        } else if (!describeApplicationVersionsRequest.versionLabels().isEmpty() && !(describeApplicationVersionsRequest.versionLabels() instanceof SdkAutoConstructList)) {
            List<String> versionLabelsList = describeApplicationVersionsRequest.versionLabels();
            int versionLabelsListIndex = 1;
            for (String versionLabelsListValue : versionLabelsList) {
                if (versionLabelsListValue != null) {
                    request.addParameter("VersionLabels.member." + versionLabelsListIndex, StringConversion.fromString((String)versionLabelsListValue));
                }
                ++versionLabelsListIndex;
            }
        }
        if (describeApplicationVersionsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringConversion.fromInteger((Integer)describeApplicationVersionsRequest.maxRecords()));
        }
        if (describeApplicationVersionsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)describeApplicationVersionsRequest.nextToken()));
        }
        return request;
    }
}

