/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticbeanstalk.model.DeleteApplicationRequest;

public class DeleteApplicationRequestMarshaller
implements Marshaller<Request<DeleteApplicationRequest>, DeleteApplicationRequest> {
    public Request<DeleteApplicationRequest> marshall(DeleteApplicationRequest deleteApplicationRequest) {
        if (deleteApplicationRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)deleteApplicationRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "DeleteApplication");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteApplicationRequest.applicationName() != null) {
            request.addParameter("ApplicationName", StringConversion.fromString((String)deleteApplicationRequest.applicationName()));
        }
        if (deleteApplicationRequest.terminateEnvByForce() != null) {
            request.addParameter("TerminateEnvByForce", StringConversion.fromBoolean((Boolean)deleteApplicationRequest.terminateEnvByForce()));
        }
        return request;
    }
}

