/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticbeanstalk.model.ComposeEnvironmentsRequest;

public class ComposeEnvironmentsRequestMarshaller
implements Marshaller<Request<ComposeEnvironmentsRequest>, ComposeEnvironmentsRequest> {
    public Request<ComposeEnvironmentsRequest> marshall(ComposeEnvironmentsRequest composeEnvironmentsRequest) {
        if (composeEnvironmentsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)composeEnvironmentsRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "ComposeEnvironments");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (composeEnvironmentsRequest.applicationName() != null) {
            request.addParameter("ApplicationName", StringConversion.fromString((String)composeEnvironmentsRequest.applicationName()));
        }
        if (composeEnvironmentsRequest.groupName() != null) {
            request.addParameter("GroupName", StringConversion.fromString((String)composeEnvironmentsRequest.groupName()));
        }
        if (composeEnvironmentsRequest.versionLabels().isEmpty() && !(composeEnvironmentsRequest.versionLabels() instanceof SdkAutoConstructList)) {
            request.addParameter("VersionLabels", "");
        } else if (!composeEnvironmentsRequest.versionLabels().isEmpty() && !(composeEnvironmentsRequest.versionLabels() instanceof SdkAutoConstructList)) {
            List<String> versionLabelsList = composeEnvironmentsRequest.versionLabels();
            int versionLabelsListIndex = 1;
            for (String versionLabelsListValue : versionLabelsList) {
                if (versionLabelsListValue != null) {
                    request.addParameter("VersionLabels.member." + versionLabelsListIndex, StringConversion.fromString((String)versionLabelsListValue));
                }
                ++versionLabelsListIndex;
            }
        }
        return request;
    }
}

