/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.model.CPUUtilization;

public class CPUUtilizationUnmarshaller
implements Unmarshaller<CPUUtilization, StaxUnmarshallerContext> {
    private static final CPUUtilizationUnmarshaller INSTANCE = new CPUUtilizationUnmarshaller();

    public CPUUtilization unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        CPUUtilization.Builder cpuUtilization = CPUUtilization.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("User", targetDepth)) {
                    cpuUtilization.user(SimpleTypeStaxUnmarshallers.DoubleUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Nice", targetDepth)) {
                    cpuUtilization.nice(SimpleTypeStaxUnmarshallers.DoubleUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("System", targetDepth)) {
                    cpuUtilization.system(SimpleTypeStaxUnmarshallers.DoubleUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Idle", targetDepth)) {
                    cpuUtilization.idle(SimpleTypeStaxUnmarshallers.DoubleUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("IOWait", targetDepth)) {
                    cpuUtilization.ioWait(SimpleTypeStaxUnmarshallers.DoubleUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("IRQ", targetDepth)) {
                    cpuUtilization.irq(SimpleTypeStaxUnmarshallers.DoubleUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SoftIRQ", targetDepth)) {
                    cpuUtilization.softIRQ(SimpleTypeStaxUnmarshallers.DoubleUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Privileged", targetDepth)) continue;
                cpuUtilization.privileged(SimpleTypeStaxUnmarshallers.DoubleUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (CPUUtilization)cpuUtilization.build();
    }

    public static CPUUtilizationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

