/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SwapEnvironmentCnamEsRequest
extends ElasticBeanstalkRequest
implements ToCopyableBuilder<Builder, SwapEnvironmentCnamEsRequest> {
    private final String sourceEnvironmentId;
    private final String sourceEnvironmentName;
    private final String destinationEnvironmentId;
    private final String destinationEnvironmentName;

    private SwapEnvironmentCnamEsRequest(BuilderImpl builder) {
        super(builder);
        this.sourceEnvironmentId = builder.sourceEnvironmentId;
        this.sourceEnvironmentName = builder.sourceEnvironmentName;
        this.destinationEnvironmentId = builder.destinationEnvironmentId;
        this.destinationEnvironmentName = builder.destinationEnvironmentName;
    }

    public String sourceEnvironmentId() {
        return this.sourceEnvironmentId;
    }

    public String sourceEnvironmentName() {
        return this.sourceEnvironmentName;
    }

    public String destinationEnvironmentId() {
        return this.destinationEnvironmentId;
    }

    public String destinationEnvironmentName() {
        return this.destinationEnvironmentName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceEnvironmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceEnvironmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationEnvironmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationEnvironmentName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SwapEnvironmentCnamEsRequest)) {
            return false;
        }
        SwapEnvironmentCnamEsRequest other = (SwapEnvironmentCnamEsRequest)((Object)obj);
        return Objects.equals(this.sourceEnvironmentId(), other.sourceEnvironmentId()) && Objects.equals(this.sourceEnvironmentName(), other.sourceEnvironmentName()) && Objects.equals(this.destinationEnvironmentId(), other.destinationEnvironmentId()) && Objects.equals(this.destinationEnvironmentName(), other.destinationEnvironmentName());
    }

    public String toString() {
        return ToString.builder((String)"SwapEnvironmentCnamEsRequest").add("SourceEnvironmentId", (Object)this.sourceEnvironmentId()).add("SourceEnvironmentName", (Object)this.sourceEnvironmentName()).add("DestinationEnvironmentId", (Object)this.destinationEnvironmentId()).add("DestinationEnvironmentName", (Object)this.destinationEnvironmentName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceEnvironmentId": {
                return Optional.ofNullable(clazz.cast(this.sourceEnvironmentId()));
            }
            case "SourceEnvironmentName": {
                return Optional.ofNullable(clazz.cast(this.sourceEnvironmentName()));
            }
            case "DestinationEnvironmentId": {
                return Optional.ofNullable(clazz.cast(this.destinationEnvironmentId()));
            }
            case "DestinationEnvironmentName": {
                return Optional.ofNullable(clazz.cast(this.destinationEnvironmentName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticBeanstalkRequest.BuilderImpl
    implements Builder {
        private String sourceEnvironmentId;
        private String sourceEnvironmentName;
        private String destinationEnvironmentId;
        private String destinationEnvironmentName;

        private BuilderImpl() {
        }

        private BuilderImpl(SwapEnvironmentCnamEsRequest model) {
            super(model);
            this.sourceEnvironmentId(model.sourceEnvironmentId);
            this.sourceEnvironmentName(model.sourceEnvironmentName);
            this.destinationEnvironmentId(model.destinationEnvironmentId);
            this.destinationEnvironmentName(model.destinationEnvironmentName);
        }

        public final String getSourceEnvironmentId() {
            return this.sourceEnvironmentId;
        }

        @Override
        public final Builder sourceEnvironmentId(String sourceEnvironmentId) {
            this.sourceEnvironmentId = sourceEnvironmentId;
            return this;
        }

        public final void setSourceEnvironmentId(String sourceEnvironmentId) {
            this.sourceEnvironmentId = sourceEnvironmentId;
        }

        public final String getSourceEnvironmentName() {
            return this.sourceEnvironmentName;
        }

        @Override
        public final Builder sourceEnvironmentName(String sourceEnvironmentName) {
            this.sourceEnvironmentName = sourceEnvironmentName;
            return this;
        }

        public final void setSourceEnvironmentName(String sourceEnvironmentName) {
            this.sourceEnvironmentName = sourceEnvironmentName;
        }

        public final String getDestinationEnvironmentId() {
            return this.destinationEnvironmentId;
        }

        @Override
        public final Builder destinationEnvironmentId(String destinationEnvironmentId) {
            this.destinationEnvironmentId = destinationEnvironmentId;
            return this;
        }

        public final void setDestinationEnvironmentId(String destinationEnvironmentId) {
            this.destinationEnvironmentId = destinationEnvironmentId;
        }

        public final String getDestinationEnvironmentName() {
            return this.destinationEnvironmentName;
        }

        @Override
        public final Builder destinationEnvironmentName(String destinationEnvironmentName) {
            this.destinationEnvironmentName = destinationEnvironmentName;
            return this;
        }

        public final void setDestinationEnvironmentName(String destinationEnvironmentName) {
            this.destinationEnvironmentName = destinationEnvironmentName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SwapEnvironmentCnamEsRequest build() {
            return new SwapEnvironmentCnamEsRequest(this);
        }
    }

    public static interface Builder
    extends ElasticBeanstalkRequest.Builder,
    CopyableBuilder<Builder, SwapEnvironmentCnamEsRequest> {
        public Builder sourceEnvironmentId(String var1);

        public Builder sourceEnvironmentName(String var1);

        public Builder destinationEnvironmentId(String var1);

        public Builder destinationEnvironmentName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

