/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationSettingsDescription;
import software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationSettingsDescriptionListCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeConfigurationSettingsResponse
extends ElasticBeanstalkResponse
implements ToCopyableBuilder<Builder, DescribeConfigurationSettingsResponse> {
    private final List<ConfigurationSettingsDescription> configurationSettings;

    private DescribeConfigurationSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.configurationSettings = builder.configurationSettings;
    }

    public List<ConfigurationSettingsDescription> configurationSettings() {
        return this.configurationSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationSettings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationSettingsResponse)) {
            return false;
        }
        DescribeConfigurationSettingsResponse other = (DescribeConfigurationSettingsResponse)((Object)obj);
        return Objects.equals(this.configurationSettings(), other.configurationSettings());
    }

    public String toString() {
        return ToString.builder((String)"DescribeConfigurationSettingsResponse").add("ConfigurationSettings", this.configurationSettings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationSettings": {
                return Optional.ofNullable(clazz.cast(this.configurationSettings()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticBeanstalkResponse.BuilderImpl
    implements Builder {
        private List<ConfigurationSettingsDescription> configurationSettings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationSettingsResponse model) {
            super(model);
            this.configurationSettings(model.configurationSettings);
        }

        public final Collection<ConfigurationSettingsDescription.Builder> getConfigurationSettings() {
            return this.configurationSettings != null ? (Collection)this.configurationSettings.stream().map(ConfigurationSettingsDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder configurationSettings(Collection<ConfigurationSettingsDescription> configurationSettings) {
            this.configurationSettings = ConfigurationSettingsDescriptionListCopier.copy(configurationSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationSettings(ConfigurationSettingsDescription ... configurationSettings) {
            this.configurationSettings(Arrays.asList(configurationSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationSettings(Consumer<ConfigurationSettingsDescription.Builder> ... configurationSettings) {
            this.configurationSettings(Stream.of(configurationSettings).map(c -> (ConfigurationSettingsDescription)((ConfigurationSettingsDescription.Builder)ConfigurationSettingsDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConfigurationSettings(Collection<ConfigurationSettingsDescription.BuilderImpl> configurationSettings) {
            this.configurationSettings = ConfigurationSettingsDescriptionListCopier.copyFromBuilder(configurationSettings);
        }

        @Override
        public DescribeConfigurationSettingsResponse build() {
            return new DescribeConfigurationSettingsResponse(this);
        }
    }

    public static interface Builder
    extends ElasticBeanstalkResponse.Builder,
    CopyableBuilder<Builder, DescribeConfigurationSettingsResponse> {
        public Builder configurationSettings(Collection<ConfigurationSettingsDescription> var1);

        public Builder configurationSettings(ConfigurationSettingsDescription ... var1);

        public Builder configurationSettings(Consumer<ConfigurationSettingsDescription.Builder> ... var1);
    }
}

