/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionDescription;
import software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionDescriptionsListCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeConfigurationOptionsResponse
extends ElasticBeanstalkResponse
implements ToCopyableBuilder<Builder, DescribeConfigurationOptionsResponse> {
    private final String solutionStackName;
    private final String platformArn;
    private final List<ConfigurationOptionDescription> options;

    private DescribeConfigurationOptionsResponse(BuilderImpl builder) {
        super(builder);
        this.solutionStackName = builder.solutionStackName;
        this.platformArn = builder.platformArn;
        this.options = builder.options;
    }

    public String solutionStackName() {
        return this.solutionStackName;
    }

    public String platformArn() {
        return this.platformArn;
    }

    public List<ConfigurationOptionDescription> options() {
        return this.options;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.solutionStackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.options());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationOptionsResponse)) {
            return false;
        }
        DescribeConfigurationOptionsResponse other = (DescribeConfigurationOptionsResponse)((Object)obj);
        return Objects.equals(this.solutionStackName(), other.solutionStackName()) && Objects.equals(this.platformArn(), other.platformArn()) && Objects.equals(this.options(), other.options());
    }

    public String toString() {
        return ToString.builder((String)"DescribeConfigurationOptionsResponse").add("SolutionStackName", (Object)this.solutionStackName()).add("PlatformArn", (Object)this.platformArn()).add("Options", this.options()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SolutionStackName": {
                return Optional.ofNullable(clazz.cast(this.solutionStackName()));
            }
            case "PlatformArn": {
                return Optional.ofNullable(clazz.cast(this.platformArn()));
            }
            case "Options": {
                return Optional.ofNullable(clazz.cast(this.options()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticBeanstalkResponse.BuilderImpl
    implements Builder {
        private String solutionStackName;
        private String platformArn;
        private List<ConfigurationOptionDescription> options = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationOptionsResponse model) {
            super(model);
            this.solutionStackName(model.solutionStackName);
            this.platformArn(model.platformArn);
            this.options(model.options);
        }

        public final String getSolutionStackName() {
            return this.solutionStackName;
        }

        @Override
        public final Builder solutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
            return this;
        }

        public final void setSolutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
        }

        public final String getPlatformArn() {
            return this.platformArn;
        }

        @Override
        public final Builder platformArn(String platformArn) {
            this.platformArn = platformArn;
            return this;
        }

        public final void setPlatformArn(String platformArn) {
            this.platformArn = platformArn;
        }

        public final Collection<ConfigurationOptionDescription.Builder> getOptions() {
            return this.options != null ? (Collection)this.options.stream().map(ConfigurationOptionDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder options(Collection<ConfigurationOptionDescription> options) {
            this.options = ConfigurationOptionDescriptionsListCopier.copy(options);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(ConfigurationOptionDescription ... options) {
            this.options(Arrays.asList(options));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(Consumer<ConfigurationOptionDescription.Builder> ... options) {
            this.options(Stream.of(options).map(c -> (ConfigurationOptionDescription)((ConfigurationOptionDescription.Builder)ConfigurationOptionDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOptions(Collection<ConfigurationOptionDescription.BuilderImpl> options) {
            this.options = ConfigurationOptionDescriptionsListCopier.copyFromBuilder(options);
        }

        @Override
        public DescribeConfigurationOptionsResponse build() {
            return new DescribeConfigurationOptionsResponse(this);
        }
    }

    public static interface Builder
    extends ElasticBeanstalkResponse.Builder,
    CopyableBuilder<Builder, DescribeConfigurationOptionsResponse> {
        public Builder solutionStackName(String var1);

        public Builder platformArn(String var1);

        public Builder options(Collection<ConfigurationOptionDescription> var1);

        public Builder options(ConfigurationOptionDescription ... var1);

        public Builder options(Consumer<ConfigurationOptionDescription.Builder> ... var1);
    }
}

