/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CheckDnsAvailabilityRequest
extends ElasticBeanstalkRequest
implements ToCopyableBuilder<Builder, CheckDnsAvailabilityRequest> {
    private final String cnamePrefix;

    private CheckDnsAvailabilityRequest(BuilderImpl builder) {
        super(builder);
        this.cnamePrefix = builder.cnamePrefix;
    }

    public String cnamePrefix() {
        return this.cnamePrefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cnamePrefix());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckDnsAvailabilityRequest)) {
            return false;
        }
        CheckDnsAvailabilityRequest other = (CheckDnsAvailabilityRequest)((Object)obj);
        return Objects.equals(this.cnamePrefix(), other.cnamePrefix());
    }

    public String toString() {
        return ToString.builder((String)"CheckDnsAvailabilityRequest").add("CNAMEPrefix", (Object)this.cnamePrefix()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CNAMEPrefix": {
                return Optional.ofNullable(clazz.cast(this.cnamePrefix()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticBeanstalkRequest.BuilderImpl
    implements Builder {
        private String cnamePrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(CheckDnsAvailabilityRequest model) {
            super(model);
            this.cnamePrefix(model.cnamePrefix);
        }

        public final String getCNAMEPrefix() {
            return this.cnamePrefix;
        }

        @Override
        public final Builder cnamePrefix(String cnamePrefix) {
            this.cnamePrefix = cnamePrefix;
            return this;
        }

        public final void setCNAMEPrefix(String cnamePrefix) {
            this.cnamePrefix = cnamePrefix;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CheckDnsAvailabilityRequest build() {
            return new CheckDnsAvailabilityRequest(this);
        }
    }

    public static interface Builder
    extends ElasticBeanstalkRequest.Builder,
    CopyableBuilder<Builder, CheckDnsAvailabilityRequest> {
        public Builder cnamePrefix(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

