/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CPUUtilization
implements ToCopyableBuilder<Builder, CPUUtilization> {
    private final Double user;
    private final Double nice;
    private final Double system;
    private final Double idle;
    private final Double ioWait;
    private final Double irq;
    private final Double softIRQ;
    private final Double privileged;

    private CPUUtilization(BuilderImpl builder) {
        this.user = builder.user;
        this.nice = builder.nice;
        this.system = builder.system;
        this.idle = builder.idle;
        this.ioWait = builder.ioWait;
        this.irq = builder.irq;
        this.softIRQ = builder.softIRQ;
        this.privileged = builder.privileged;
    }

    public Double user() {
        return this.user;
    }

    public Double nice() {
        return this.nice;
    }

    public Double system() {
        return this.system;
    }

    public Double idle() {
        return this.idle;
    }

    public Double ioWait() {
        return this.ioWait;
    }

    public Double irq() {
        return this.irq;
    }

    public Double softIRQ() {
        return this.softIRQ;
    }

    public Double privileged() {
        return this.privileged;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.user());
        hashCode = 31 * hashCode + Objects.hashCode(this.nice());
        hashCode = 31 * hashCode + Objects.hashCode(this.system());
        hashCode = 31 * hashCode + Objects.hashCode(this.idle());
        hashCode = 31 * hashCode + Objects.hashCode(this.ioWait());
        hashCode = 31 * hashCode + Objects.hashCode(this.irq());
        hashCode = 31 * hashCode + Objects.hashCode(this.softIRQ());
        hashCode = 31 * hashCode + Objects.hashCode(this.privileged());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CPUUtilization)) {
            return false;
        }
        CPUUtilization other = (CPUUtilization)obj;
        return Objects.equals(this.user(), other.user()) && Objects.equals(this.nice(), other.nice()) && Objects.equals(this.system(), other.system()) && Objects.equals(this.idle(), other.idle()) && Objects.equals(this.ioWait(), other.ioWait()) && Objects.equals(this.irq(), other.irq()) && Objects.equals(this.softIRQ(), other.softIRQ()) && Objects.equals(this.privileged(), other.privileged());
    }

    public String toString() {
        return ToString.builder((String)"CPUUtilization").add("User", (Object)this.user()).add("Nice", (Object)this.nice()).add("System", (Object)this.system()).add("Idle", (Object)this.idle()).add("IOWait", (Object)this.ioWait()).add("IRQ", (Object)this.irq()).add("SoftIRQ", (Object)this.softIRQ()).add("Privileged", (Object)this.privileged()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "User": {
                return Optional.ofNullable(clazz.cast(this.user()));
            }
            case "Nice": {
                return Optional.ofNullable(clazz.cast(this.nice()));
            }
            case "System": {
                return Optional.ofNullable(clazz.cast(this.system()));
            }
            case "Idle": {
                return Optional.ofNullable(clazz.cast(this.idle()));
            }
            case "IOWait": {
                return Optional.ofNullable(clazz.cast(this.ioWait()));
            }
            case "IRQ": {
                return Optional.ofNullable(clazz.cast(this.irq()));
            }
            case "SoftIRQ": {
                return Optional.ofNullable(clazz.cast(this.softIRQ()));
            }
            case "Privileged": {
                return Optional.ofNullable(clazz.cast(this.privileged()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Double user;
        private Double nice;
        private Double system;
        private Double idle;
        private Double ioWait;
        private Double irq;
        private Double softIRQ;
        private Double privileged;

        private BuilderImpl() {
        }

        private BuilderImpl(CPUUtilization model) {
            this.user(model.user);
            this.nice(model.nice);
            this.system(model.system);
            this.idle(model.idle);
            this.ioWait(model.ioWait);
            this.irq(model.irq);
            this.softIRQ(model.softIRQ);
            this.privileged(model.privileged);
        }

        public final Double getUser() {
            return this.user;
        }

        @Override
        public final Builder user(Double user) {
            this.user = user;
            return this;
        }

        public final void setUser(Double user) {
            this.user = user;
        }

        public final Double getNice() {
            return this.nice;
        }

        @Override
        public final Builder nice(Double nice) {
            this.nice = nice;
            return this;
        }

        public final void setNice(Double nice) {
            this.nice = nice;
        }

        public final Double getSystem() {
            return this.system;
        }

        @Override
        public final Builder system(Double system) {
            this.system = system;
            return this;
        }

        public final void setSystem(Double system) {
            this.system = system;
        }

        public final Double getIdle() {
            return this.idle;
        }

        @Override
        public final Builder idle(Double idle) {
            this.idle = idle;
            return this;
        }

        public final void setIdle(Double idle) {
            this.idle = idle;
        }

        public final Double getIOWait() {
            return this.ioWait;
        }

        @Override
        public final Builder ioWait(Double ioWait) {
            this.ioWait = ioWait;
            return this;
        }

        public final void setIOWait(Double ioWait) {
            this.ioWait = ioWait;
        }

        public final Double getIRQ() {
            return this.irq;
        }

        @Override
        public final Builder irq(Double irq) {
            this.irq = irq;
            return this;
        }

        public final void setIRQ(Double irq) {
            this.irq = irq;
        }

        public final Double getSoftIRQ() {
            return this.softIRQ;
        }

        @Override
        public final Builder softIRQ(Double softIRQ) {
            this.softIRQ = softIRQ;
            return this;
        }

        public final void setSoftIRQ(Double softIRQ) {
            this.softIRQ = softIRQ;
        }

        public final Double getPrivileged() {
            return this.privileged;
        }

        @Override
        public final Builder privileged(Double privileged) {
            this.privileged = privileged;
            return this;
        }

        public final void setPrivileged(Double privileged) {
            this.privileged = privileged;
        }

        public CPUUtilization build() {
            return new CPUUtilization(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CPUUtilization> {
        public Builder user(Double var1);

        public Builder nice(Double var1);

        public Builder system(Double var1);

        public Builder idle(Double var1);

        public Builder ioWait(Double var1);

        public Builder irq(Double var1);

        public Builder softIRQ(Double var1);

        public Builder privileged(Double var1);
    }
}

