/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticbeanstalk.model.SwapEnvironmentCnamEsRequest;

public class SwapEnvironmentCnamEsRequestMarshaller
implements Marshaller<Request<SwapEnvironmentCnamEsRequest>, SwapEnvironmentCnamEsRequest> {
    public Request<SwapEnvironmentCnamEsRequest> marshall(SwapEnvironmentCnamEsRequest swapEnvironmentCnamEsRequest) {
        if (swapEnvironmentCnamEsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)swapEnvironmentCnamEsRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "SwapEnvironmentCNAMEs");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (swapEnvironmentCnamEsRequest.sourceEnvironmentId() != null) {
            request.addParameter("SourceEnvironmentId", StringConversion.fromString((String)swapEnvironmentCnamEsRequest.sourceEnvironmentId()));
        }
        if (swapEnvironmentCnamEsRequest.sourceEnvironmentName() != null) {
            request.addParameter("SourceEnvironmentName", StringConversion.fromString((String)swapEnvironmentCnamEsRequest.sourceEnvironmentName()));
        }
        if (swapEnvironmentCnamEsRequest.destinationEnvironmentId() != null) {
            request.addParameter("DestinationEnvironmentId", StringConversion.fromString((String)swapEnvironmentCnamEsRequest.destinationEnvironmentId()));
        }
        if (swapEnvironmentCnamEsRequest.destinationEnvironmentName() != null) {
            request.addParameter("DestinationEnvironmentName", StringConversion.fromString((String)swapEnvironmentCnamEsRequest.destinationEnvironmentName()));
        }
        return request;
    }
}

