/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeInstancesHealthRequest;

public class DescribeInstancesHealthRequestMarshaller
implements Marshaller<Request<DescribeInstancesHealthRequest>, DescribeInstancesHealthRequest> {
    public Request<DescribeInstancesHealthRequest> marshall(DescribeInstancesHealthRequest describeInstancesHealthRequest) {
        if (describeInstancesHealthRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeInstancesHealthRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "DescribeInstancesHealth");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeInstancesHealthRequest.environmentName() != null) {
            request.addParameter("EnvironmentName", StringConversion.fromString((String)describeInstancesHealthRequest.environmentName()));
        }
        if (describeInstancesHealthRequest.environmentId() != null) {
            request.addParameter("EnvironmentId", StringConversion.fromString((String)describeInstancesHealthRequest.environmentId()));
        }
        if (describeInstancesHealthRequest.attributeNamesAsStrings().isEmpty() && !(describeInstancesHealthRequest.attributeNamesAsStrings() instanceof SdkAutoConstructList)) {
            request.addParameter("AttributeNames", "");
        } else if (!describeInstancesHealthRequest.attributeNamesAsStrings().isEmpty() && !(describeInstancesHealthRequest.attributeNamesAsStrings() instanceof SdkAutoConstructList)) {
            List<String> attributeNamesList = describeInstancesHealthRequest.attributeNamesAsStrings();
            int attributeNamesListIndex = 1;
            for (String attributeNamesListValue : attributeNamesList) {
                if (attributeNamesListValue != null) {
                    request.addParameter("AttributeNames.member." + attributeNamesListIndex, StringConversion.fromString((String)attributeNamesListValue));
                }
                ++attributeNamesListIndex;
            }
        }
        if (describeInstancesHealthRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)describeInstancesHealthRequest.nextToken()));
        }
        return request;
    }
}

