/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentHealthRequest;

public class DescribeEnvironmentHealthRequestMarshaller
implements Marshaller<Request<DescribeEnvironmentHealthRequest>, DescribeEnvironmentHealthRequest> {
    public Request<DescribeEnvironmentHealthRequest> marshall(DescribeEnvironmentHealthRequest describeEnvironmentHealthRequest) {
        if (describeEnvironmentHealthRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeEnvironmentHealthRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "DescribeEnvironmentHealth");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeEnvironmentHealthRequest.environmentName() != null) {
            request.addParameter("EnvironmentName", StringConversion.fromString((String)describeEnvironmentHealthRequest.environmentName()));
        }
        if (describeEnvironmentHealthRequest.environmentId() != null) {
            request.addParameter("EnvironmentId", StringConversion.fromString((String)describeEnvironmentHealthRequest.environmentId()));
        }
        if (describeEnvironmentHealthRequest.attributeNamesAsStrings().isEmpty() && !(describeEnvironmentHealthRequest.attributeNamesAsStrings() instanceof SdkAutoConstructList)) {
            request.addParameter("AttributeNames", "");
        } else if (!describeEnvironmentHealthRequest.attributeNamesAsStrings().isEmpty() && !(describeEnvironmentHealthRequest.attributeNamesAsStrings() instanceof SdkAutoConstructList)) {
            List<String> attributeNamesList = describeEnvironmentHealthRequest.attributeNamesAsStrings();
            int attributeNamesListIndex = 1;
            for (String attributeNamesListValue : attributeNamesList) {
                if (attributeNamesListValue != null) {
                    request.addParameter("AttributeNames.member." + attributeNamesListIndex, StringConversion.fromString((String)attributeNamesListValue));
                }
                ++attributeNamesListIndex;
            }
        }
        return request;
    }
}

