/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticbeanstalk.model.DeleteConfigurationTemplateRequest;

public class DeleteConfigurationTemplateRequestMarshaller
implements Marshaller<Request<DeleteConfigurationTemplateRequest>, DeleteConfigurationTemplateRequest> {
    public Request<DeleteConfigurationTemplateRequest> marshall(DeleteConfigurationTemplateRequest deleteConfigurationTemplateRequest) {
        if (deleteConfigurationTemplateRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)deleteConfigurationTemplateRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "DeleteConfigurationTemplate");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteConfigurationTemplateRequest.applicationName() != null) {
            request.addParameter("ApplicationName", StringConversion.fromString((String)deleteConfigurationTemplateRequest.applicationName()));
        }
        if (deleteConfigurationTemplateRequest.templateName() != null) {
            request.addParameter("TemplateName", StringConversion.fromString((String)deleteConfigurationTemplateRequest.templateName()));
        }
        return request;
    }
}

