/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticbeanstalk.model.BuildConfiguration;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreateApplicationVersionRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.S3Location;
import software.amazon.awssdk.services.elasticbeanstalk.model.SourceBuildInformation;

public class CreateApplicationVersionRequestMarshaller
implements Marshaller<Request<CreateApplicationVersionRequest>, CreateApplicationVersionRequest> {
    public Request<CreateApplicationVersionRequest> marshall(CreateApplicationVersionRequest createApplicationVersionRequest) {
        BuildConfiguration buildConfiguration;
        S3Location sourceBundle;
        SourceBuildInformation sourceBuildInformation;
        if (createApplicationVersionRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createApplicationVersionRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "CreateApplicationVersion");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createApplicationVersionRequest.applicationName() != null) {
            request.addParameter("ApplicationName", StringConversion.fromString((String)createApplicationVersionRequest.applicationName()));
        }
        if (createApplicationVersionRequest.versionLabel() != null) {
            request.addParameter("VersionLabel", StringConversion.fromString((String)createApplicationVersionRequest.versionLabel()));
        }
        if (createApplicationVersionRequest.description() != null) {
            request.addParameter("Description", StringConversion.fromString((String)createApplicationVersionRequest.description()));
        }
        if ((sourceBuildInformation = createApplicationVersionRequest.sourceBuildInformation()) != null) {
            if (sourceBuildInformation.sourceTypeAsString() != null) {
                request.addParameter("SourceBuildInformation.SourceType", StringConversion.fromString((String)sourceBuildInformation.sourceTypeAsString()));
            }
            if (sourceBuildInformation.sourceRepositoryAsString() != null) {
                request.addParameter("SourceBuildInformation.SourceRepository", StringConversion.fromString((String)sourceBuildInformation.sourceRepositoryAsString()));
            }
            if (sourceBuildInformation.sourceLocation() != null) {
                request.addParameter("SourceBuildInformation.SourceLocation", StringConversion.fromString((String)sourceBuildInformation.sourceLocation()));
            }
        }
        if ((sourceBundle = createApplicationVersionRequest.sourceBundle()) != null) {
            if (sourceBundle.s3Bucket() != null) {
                request.addParameter("SourceBundle.S3Bucket", StringConversion.fromString((String)sourceBundle.s3Bucket()));
            }
            if (sourceBundle.s3Key() != null) {
                request.addParameter("SourceBundle.S3Key", StringConversion.fromString((String)sourceBundle.s3Key()));
            }
        }
        if ((buildConfiguration = createApplicationVersionRequest.buildConfiguration()) != null) {
            if (buildConfiguration.artifactName() != null) {
                request.addParameter("BuildConfiguration.ArtifactName", StringConversion.fromString((String)buildConfiguration.artifactName()));
            }
            if (buildConfiguration.codeBuildServiceRole() != null) {
                request.addParameter("BuildConfiguration.CodeBuildServiceRole", StringConversion.fromString((String)buildConfiguration.codeBuildServiceRole()));
            }
            if (buildConfiguration.computeTypeAsString() != null) {
                request.addParameter("BuildConfiguration.ComputeType", StringConversion.fromString((String)buildConfiguration.computeTypeAsString()));
            }
            if (buildConfiguration.image() != null) {
                request.addParameter("BuildConfiguration.Image", StringConversion.fromString((String)buildConfiguration.image()));
            }
            if (buildConfiguration.timeoutInMinutes() != null) {
                request.addParameter("BuildConfiguration.TimeoutInMinutes", StringConversion.fromInteger((Integer)buildConfiguration.timeoutInMinutes()));
            }
        }
        if (createApplicationVersionRequest.autoCreateApplication() != null) {
            request.addParameter("AutoCreateApplication", StringConversion.fromBoolean((Boolean)createApplicationVersionRequest.autoCreateApplication()));
        }
        if (createApplicationVersionRequest.process() != null) {
            request.addParameter("Process", StringConversion.fromBoolean((Boolean)createApplicationVersionRequest.process()));
        }
        return request;
    }
}

