/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationMetrics;
import software.amazon.awssdk.services.elasticbeanstalk.model.CausesCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.Deployment;
import software.amazon.awssdk.services.elasticbeanstalk.model.SystemStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SingleInstanceHealth
implements ToCopyableBuilder<Builder, SingleInstanceHealth> {
    private final String instanceId;
    private final String healthStatus;
    private final String color;
    private final List<String> causes;
    private final Instant launchedAt;
    private final ApplicationMetrics applicationMetrics;
    private final SystemStatus system;
    private final Deployment deployment;
    private final String availabilityZone;
    private final String instanceType;

    private SingleInstanceHealth(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.healthStatus = builder.healthStatus;
        this.color = builder.color;
        this.causes = builder.causes;
        this.launchedAt = builder.launchedAt;
        this.applicationMetrics = builder.applicationMetrics;
        this.system = builder.system;
        this.deployment = builder.deployment;
        this.availabilityZone = builder.availabilityZone;
        this.instanceType = builder.instanceType;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String healthStatus() {
        return this.healthStatus;
    }

    public String color() {
        return this.color;
    }

    public List<String> causes() {
        return this.causes;
    }

    public Instant launchedAt() {
        return this.launchedAt;
    }

    public ApplicationMetrics applicationMetrics() {
        return this.applicationMetrics;
    }

    public SystemStatus system() {
        return this.system;
    }

    public Deployment deployment() {
        return this.deployment;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.color());
        hashCode = 31 * hashCode + Objects.hashCode(this.causes());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.system());
        hashCode = 31 * hashCode + Objects.hashCode(this.deployment());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SingleInstanceHealth)) {
            return false;
        }
        SingleInstanceHealth other = (SingleInstanceHealth)obj;
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.healthStatus(), other.healthStatus()) && Objects.equals(this.color(), other.color()) && Objects.equals(this.causes(), other.causes()) && Objects.equals(this.launchedAt(), other.launchedAt()) && Objects.equals(this.applicationMetrics(), other.applicationMetrics()) && Objects.equals(this.system(), other.system()) && Objects.equals(this.deployment(), other.deployment()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.instanceType(), other.instanceType());
    }

    public String toString() {
        return ToString.builder((String)"SingleInstanceHealth").add("InstanceId", (Object)this.instanceId()).add("HealthStatus", (Object)this.healthStatus()).add("Color", (Object)this.color()).add("Causes", this.causes()).add("LaunchedAt", (Object)this.launchedAt()).add("ApplicationMetrics", (Object)this.applicationMetrics()).add("System", (Object)this.system()).add("Deployment", (Object)this.deployment()).add("AvailabilityZone", (Object)this.availabilityZone()).add("InstanceType", (Object)this.instanceType()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "HealthStatus": {
                return Optional.ofNullable(clazz.cast(this.healthStatus()));
            }
            case "Color": {
                return Optional.ofNullable(clazz.cast(this.color()));
            }
            case "Causes": {
                return Optional.ofNullable(clazz.cast(this.causes()));
            }
            case "LaunchedAt": {
                return Optional.ofNullable(clazz.cast(this.launchedAt()));
            }
            case "ApplicationMetrics": {
                return Optional.ofNullable(clazz.cast(this.applicationMetrics()));
            }
            case "System": {
                return Optional.ofNullable(clazz.cast(this.system()));
            }
            case "Deployment": {
                return Optional.ofNullable(clazz.cast(this.deployment()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private String healthStatus;
        private String color;
        private List<String> causes = DefaultSdkAutoConstructList.getInstance();
        private Instant launchedAt;
        private ApplicationMetrics applicationMetrics;
        private SystemStatus system;
        private Deployment deployment;
        private String availabilityZone;
        private String instanceType;

        private BuilderImpl() {
        }

        private BuilderImpl(SingleInstanceHealth model) {
            this.instanceId(model.instanceId);
            this.healthStatus(model.healthStatus);
            this.color(model.color);
            this.causes(model.causes);
            this.launchedAt(model.launchedAt);
            this.applicationMetrics(model.applicationMetrics);
            this.system(model.system);
            this.deployment(model.deployment);
            this.availabilityZone(model.availabilityZone);
            this.instanceType(model.instanceType);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getHealthStatus() {
            return this.healthStatus;
        }

        @Override
        public final Builder healthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
            return this;
        }

        public final void setHealthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
        }

        public final String getColor() {
            return this.color;
        }

        @Override
        public final Builder color(String color) {
            this.color = color;
            return this;
        }

        public final void setColor(String color) {
            this.color = color;
        }

        public final Collection<String> getCauses() {
            return this.causes;
        }

        @Override
        public final Builder causes(Collection<String> causes) {
            this.causes = CausesCopier.copy(causes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder causes(String ... causes) {
            this.causes(Arrays.asList(causes));
            return this;
        }

        public final void setCauses(Collection<String> causes) {
            this.causes = CausesCopier.copy(causes);
        }

        public final Instant getLaunchedAt() {
            return this.launchedAt;
        }

        @Override
        public final Builder launchedAt(Instant launchedAt) {
            this.launchedAt = launchedAt;
            return this;
        }

        public final void setLaunchedAt(Instant launchedAt) {
            this.launchedAt = launchedAt;
        }

        public final ApplicationMetrics.Builder getApplicationMetrics() {
            return this.applicationMetrics != null ? this.applicationMetrics.toBuilder() : null;
        }

        @Override
        public final Builder applicationMetrics(ApplicationMetrics applicationMetrics) {
            this.applicationMetrics = applicationMetrics;
            return this;
        }

        public final void setApplicationMetrics(ApplicationMetrics.BuilderImpl applicationMetrics) {
            this.applicationMetrics = applicationMetrics != null ? applicationMetrics.build() : null;
        }

        public final SystemStatus.Builder getSystem() {
            return this.system != null ? this.system.toBuilder() : null;
        }

        @Override
        public final Builder system(SystemStatus system) {
            this.system = system;
            return this;
        }

        public final void setSystem(SystemStatus.BuilderImpl system) {
            this.system = system != null ? system.build() : null;
        }

        public final Deployment.Builder getDeployment() {
            return this.deployment != null ? this.deployment.toBuilder() : null;
        }

        @Override
        public final Builder deployment(Deployment deployment) {
            this.deployment = deployment;
            return this;
        }

        public final void setDeployment(Deployment.BuilderImpl deployment) {
            this.deployment = deployment != null ? deployment.build() : null;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public SingleInstanceHealth build() {
            return new SingleInstanceHealth(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SingleInstanceHealth> {
        public Builder instanceId(String var1);

        public Builder healthStatus(String var1);

        public Builder color(String var1);

        public Builder causes(Collection<String> var1);

        public Builder causes(String ... var1);

        public Builder launchedAt(Instant var1);

        public Builder applicationMetrics(ApplicationMetrics var1);

        default public Builder applicationMetrics(Consumer<ApplicationMetrics.Builder> applicationMetrics) {
            return this.applicationMetrics((ApplicationMetrics)((ApplicationMetrics.Builder)ApplicationMetrics.builder().applyMutation(applicationMetrics)).build());
        }

        public Builder system(SystemStatus var1);

        default public Builder system(Consumer<SystemStatus.Builder> system) {
            return this.system((SystemStatus)((SystemStatus.Builder)SystemStatus.builder().applyMutation(system)).build());
        }

        public Builder deployment(Deployment var1);

        default public Builder deployment(Consumer<Deployment.Builder> deployment) {
            return this.deployment((Deployment)((Deployment.Builder)Deployment.builder().applyMutation(deployment)).build());
        }

        public Builder availabilityZone(String var1);

        public Builder instanceType(String var1);
    }
}

