/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEnvironmentManagedActionHistoryRequest
extends ElasticBeanstalkRequest
implements ToCopyableBuilder<Builder, DescribeEnvironmentManagedActionHistoryRequest> {
    private final String environmentId;
    private final String environmentName;
    private final String nextToken;
    private final Integer maxItems;

    private DescribeEnvironmentManagedActionHistoryRequest(BuilderImpl builder) {
        super(builder);
        this.environmentId = builder.environmentId;
        this.environmentName = builder.environmentName;
        this.nextToken = builder.nextToken;
        this.maxItems = builder.maxItems;
    }

    public String environmentId() {
        return this.environmentId;
    }

    public String environmentName() {
        return this.environmentName;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxItems() {
        return this.maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEnvironmentManagedActionHistoryRequest)) {
            return false;
        }
        DescribeEnvironmentManagedActionHistoryRequest other = (DescribeEnvironmentManagedActionHistoryRequest)((Object)obj);
        return Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.environmentName(), other.environmentName()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxItems(), other.maxItems());
    }

    public String toString() {
        return ToString.builder((String)"DescribeEnvironmentManagedActionHistoryRequest").add("EnvironmentId", (Object)this.environmentId()).add("EnvironmentName", (Object)this.environmentName()).add("NextToken", (Object)this.nextToken()).add("MaxItems", (Object)this.maxItems()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EnvironmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "EnvironmentName": {
                return Optional.ofNullable(clazz.cast(this.environmentName()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxItems": {
                return Optional.ofNullable(clazz.cast(this.maxItems()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticBeanstalkRequest.BuilderImpl
    implements Builder {
        private String environmentId;
        private String environmentName;
        private String nextToken;
        private Integer maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEnvironmentManagedActionHistoryRequest model) {
            super(model);
            this.environmentId(model.environmentId);
            this.environmentName(model.environmentName);
            this.nextToken(model.nextToken);
            this.maxItems(model.maxItems);
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeEnvironmentManagedActionHistoryRequest build() {
            return new DescribeEnvironmentManagedActionHistoryRequest(this);
        }
    }

    public static interface Builder
    extends ElasticBeanstalkRequest.Builder,
    CopyableBuilder<Builder, DescribeEnvironmentManagedActionHistoryRequest> {
        public Builder environmentId(String var1);

        public Builder environmentName(String var1);

        public Builder nextToken(String var1);

        public Builder maxItems(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

