/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.model.ValidationMessage;

public class ValidationMessageUnmarshaller
implements Unmarshaller<ValidationMessage, StaxUnmarshallerContext> {
    private static final ValidationMessageUnmarshaller INSTANCE = new ValidationMessageUnmarshaller();

    public ValidationMessage unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        ValidationMessage.Builder validationMessage = ValidationMessage.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Message", targetDepth)) {
                    validationMessage.message(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Severity", targetDepth)) {
                    validationMessage.severity(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Namespace", targetDepth)) {
                    validationMessage.namespace(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("OptionName", targetDepth)) continue;
                validationMessage.optionName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (ValidationMessage)validationMessage.build();
    }

    public static ValidationMessageUnmarshaller getInstance() {
        return INSTANCE;
    }
}

