/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticbeanstalk.model.Tag;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateTagsForResourceRequest;

public class UpdateTagsForResourceRequestMarshaller
implements Marshaller<Request<UpdateTagsForResourceRequest>, UpdateTagsForResourceRequest> {
    public Request<UpdateTagsForResourceRequest> marshall(UpdateTagsForResourceRequest updateTagsForResourceRequest) {
        List<String> tagsToRemoveList;
        List<Tag> tagsToAddList;
        if (updateTagsForResourceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)updateTagsForResourceRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "UpdateTagsForResource");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateTagsForResourceRequest.resourceArn() != null) {
            request.addParameter("ResourceArn", StringUtils.fromString((String)updateTagsForResourceRequest.resourceArn()));
        }
        if ((tagsToAddList = updateTagsForResourceRequest.tagsToAdd()) != null) {
            if (!tagsToAddList.isEmpty()) {
                int tagsToAddListIndex = 1;
                for (Tag tagsToAddListValue : tagsToAddList) {
                    if (tagsToAddListValue.key() != null) {
                        request.addParameter("TagsToAdd.member." + tagsToAddListIndex + ".Key", StringUtils.fromString((String)tagsToAddListValue.key()));
                    }
                    if (tagsToAddListValue.value() != null) {
                        request.addParameter("TagsToAdd.member." + tagsToAddListIndex + ".Value", StringUtils.fromString((String)tagsToAddListValue.value()));
                    }
                    ++tagsToAddListIndex;
                }
            } else {
                request.addParameter("TagsToAdd", "");
            }
        }
        if ((tagsToRemoveList = updateTagsForResourceRequest.tagsToRemove()) != null) {
            if (!tagsToRemoveList.isEmpty()) {
                int tagsToRemoveListIndex = 1;
                for (String tagsToRemoveListValue : tagsToRemoveList) {
                    if (tagsToRemoveListValue != null) {
                        request.addParameter("TagsToRemove.member." + tagsToRemoveListIndex, StringUtils.fromString((String)tagsToRemoveListValue));
                    }
                    ++tagsToRemoveListIndex;
                }
            } else {
                request.addParameter("TagsToRemove", "");
            }
        }
        return request;
    }
}

