/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.model.SystemStatus;
import software.amazon.awssdk.services.elasticbeanstalk.transform.CPUUtilizationUnmarshaller;

public class SystemStatusUnmarshaller
implements Unmarshaller<SystemStatus, StaxUnmarshallerContext> {
    private static final SystemStatusUnmarshaller INSTANCE = new SystemStatusUnmarshaller();

    public SystemStatus unmarshall(StaxUnmarshallerContext context) throws Exception {
        SystemStatus.Builder systemStatus;
        block6: {
            systemStatus = SystemStatus.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<Double> loadAverage = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    systemStatus.loadAverage(loadAverage);
                    break block6;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("CPUUtilization", targetDepth)) {
                        systemStatus.cpuUtilization(CPUUtilizationUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("LoadAverage", targetDepth)) {
                        loadAverage = new ArrayList<Double>();
                        continue;
                    }
                    if (!context.testExpression("LoadAverage/member", targetDepth)) continue;
                    loadAverage.add(SimpleTypeStaxUnmarshallers.DoubleUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            systemStatus.loadAverage(loadAverage);
        }
        return (SystemStatus)systemStatus.build();
    }

    public static SystemStatusUnmarshaller getInstance() {
        return INSTANCE;
    }
}

