/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticbeanstalk.model.SwapEnvironmentCNAMEsRequest;

public class SwapEnvironmentCNAMEsRequestMarshaller
implements Marshaller<Request<SwapEnvironmentCNAMEsRequest>, SwapEnvironmentCNAMEsRequest> {
    public Request<SwapEnvironmentCNAMEsRequest> marshall(SwapEnvironmentCNAMEsRequest swapEnvironmentCNAMEsRequest) {
        if (swapEnvironmentCNAMEsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)swapEnvironmentCNAMEsRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "SwapEnvironmentCNAMEs");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (swapEnvironmentCNAMEsRequest.sourceEnvironmentId() != null) {
            request.addParameter("SourceEnvironmentId", StringUtils.fromString((String)swapEnvironmentCNAMEsRequest.sourceEnvironmentId()));
        }
        if (swapEnvironmentCNAMEsRequest.sourceEnvironmentName() != null) {
            request.addParameter("SourceEnvironmentName", StringUtils.fromString((String)swapEnvironmentCNAMEsRequest.sourceEnvironmentName()));
        }
        if (swapEnvironmentCNAMEsRequest.destinationEnvironmentId() != null) {
            request.addParameter("DestinationEnvironmentId", StringUtils.fromString((String)swapEnvironmentCNAMEsRequest.destinationEnvironmentId()));
        }
        if (swapEnvironmentCNAMEsRequest.destinationEnvironmentName() != null) {
            request.addParameter("DestinationEnvironmentName", StringUtils.fromString((String)swapEnvironmentCNAMEsRequest.destinationEnvironmentName()));
        }
        return request;
    }
}

