/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentInfoDescription;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentInfoDescriptionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RetrieveEnvironmentInfoResponse
extends ElasticBeanstalkResponse
implements ToCopyableBuilder<Builder, RetrieveEnvironmentInfoResponse> {
    private final List<EnvironmentInfoDescription> environmentInfo;

    private RetrieveEnvironmentInfoResponse(BuilderImpl builder) {
        super(builder);
        this.environmentInfo = builder.environmentInfo;
    }

    public List<EnvironmentInfoDescription> environmentInfo() {
        return this.environmentInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentInfo());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetrieveEnvironmentInfoResponse)) {
            return false;
        }
        RetrieveEnvironmentInfoResponse other = (RetrieveEnvironmentInfoResponse)((Object)obj);
        return Objects.equals(this.environmentInfo(), other.environmentInfo());
    }

    public String toString() {
        return ToString.builder((String)"RetrieveEnvironmentInfoResponse").add("EnvironmentInfo", this.environmentInfo()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EnvironmentInfo": {
                return Optional.of(clazz.cast(this.environmentInfo()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticBeanstalkResponse.BuilderImpl
    implements Builder {
        private List<EnvironmentInfoDescription> environmentInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(RetrieveEnvironmentInfoResponse model) {
            super(model);
            this.environmentInfo(model.environmentInfo);
        }

        public final Collection<EnvironmentInfoDescription.Builder> getEnvironmentInfo() {
            return this.environmentInfo != null ? (Collection)this.environmentInfo.stream().map(EnvironmentInfoDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder environmentInfo(Collection<EnvironmentInfoDescription> environmentInfo) {
            this.environmentInfo = EnvironmentInfoDescriptionListCopier.copy(environmentInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentInfo(EnvironmentInfoDescription ... environmentInfo) {
            this.environmentInfo(Arrays.asList(environmentInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentInfo(Consumer<EnvironmentInfoDescription.Builder> ... environmentInfo) {
            this.environmentInfo(Stream.of(environmentInfo).map(c -> (EnvironmentInfoDescription)((EnvironmentInfoDescription.Builder)EnvironmentInfoDescription.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEnvironmentInfo(Collection<EnvironmentInfoDescription.BuilderImpl> environmentInfo) {
            this.environmentInfo = EnvironmentInfoDescriptionListCopier.copyFromBuilder(environmentInfo);
        }

        @Override
        public RetrieveEnvironmentInfoResponse build() {
            return new RetrieveEnvironmentInfoResponse(this);
        }
    }

    public static interface Builder
    extends ElasticBeanstalkResponse.Builder,
    CopyableBuilder<Builder, RetrieveEnvironmentInfoResponse> {
        public Builder environmentInfo(Collection<EnvironmentInfoDescription> var1);

        public Builder environmentInfo(EnvironmentInfoDescription ... var1);

        public Builder environmentInfo(Consumer<EnvironmentInfoDescription.Builder> ... var1);
    }
}

