/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class OptionSpecification
implements ToCopyableBuilder<Builder, OptionSpecification> {
    private final String resourceName;
    private final String namespace;
    private final String optionName;

    private OptionSpecification(BuilderImpl builder) {
        this.resourceName = builder.resourceName;
        this.namespace = builder.namespace;
        this.optionName = builder.optionName;
    }

    public String resourceName() {
        return this.resourceName;
    }

    public String namespace() {
        return this.namespace;
    }

    public String optionName() {
        return this.optionName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.optionName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptionSpecification)) {
            return false;
        }
        OptionSpecification other = (OptionSpecification)obj;
        return Objects.equals(this.resourceName(), other.resourceName()) && Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.optionName(), other.optionName());
    }

    public String toString() {
        return ToString.builder((String)"OptionSpecification").add("ResourceName", (Object)this.resourceName()).add("Namespace", (Object)this.namespace()).add("OptionName", (Object)this.optionName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceName": {
                return Optional.of(clazz.cast(this.resourceName()));
            }
            case "Namespace": {
                return Optional.of(clazz.cast(this.namespace()));
            }
            case "OptionName": {
                return Optional.of(clazz.cast(this.optionName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceName;
        private String namespace;
        private String optionName;

        private BuilderImpl() {
        }

        private BuilderImpl(OptionSpecification model) {
            this.resourceName(model.resourceName);
            this.namespace(model.namespace);
            this.optionName(model.optionName);
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public final String getOptionName() {
            return this.optionName;
        }

        @Override
        public final Builder optionName(String optionName) {
            this.optionName = optionName;
            return this;
        }

        public final void setOptionName(String optionName) {
            this.optionName = optionName;
        }

        public OptionSpecification build() {
            return new OptionSpecification(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, OptionSpecification> {
        public Builder resourceName(String var1);

        public Builder namespace(String var1);

        public Builder optionName(String var1);
    }
}

