/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.elasticbeanstalk.model.Listener;
import software.amazon.awssdk.services.elasticbeanstalk.model.LoadBalancerListenersDescriptionCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LoadBalancerDescription
implements ToCopyableBuilder<Builder, LoadBalancerDescription> {
    private final String loadBalancerName;
    private final String domain;
    private final List<Listener> listeners;

    private LoadBalancerDescription(BuilderImpl builder) {
        this.loadBalancerName = builder.loadBalancerName;
        this.domain = builder.domain;
        this.listeners = builder.listeners;
    }

    public String loadBalancerName() {
        return this.loadBalancerName;
    }

    public String domain() {
        return this.domain;
    }

    public List<Listener> listeners() {
        return this.listeners;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.listeners());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadBalancerDescription)) {
            return false;
        }
        LoadBalancerDescription other = (LoadBalancerDescription)obj;
        return Objects.equals(this.loadBalancerName(), other.loadBalancerName()) && Objects.equals(this.domain(), other.domain()) && Objects.equals(this.listeners(), other.listeners());
    }

    public String toString() {
        return ToString.builder((String)"LoadBalancerDescription").add("LoadBalancerName", (Object)this.loadBalancerName()).add("Domain", (Object)this.domain()).add("Listeners", this.listeners()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LoadBalancerName": {
                return Optional.of(clazz.cast(this.loadBalancerName()));
            }
            case "Domain": {
                return Optional.of(clazz.cast(this.domain()));
            }
            case "Listeners": {
                return Optional.of(clazz.cast(this.listeners()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String loadBalancerName;
        private String domain;
        private List<Listener> listeners;

        private BuilderImpl() {
        }

        private BuilderImpl(LoadBalancerDescription model) {
            this.loadBalancerName(model.loadBalancerName);
            this.domain(model.domain);
            this.listeners(model.listeners);
        }

        public final String getLoadBalancerName() {
            return this.loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        public final String getDomain() {
            return this.domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final Collection<Listener.Builder> getListeners() {
            return this.listeners != null ? (Collection)this.listeners.stream().map(Listener::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder listeners(Collection<Listener> listeners) {
            this.listeners = LoadBalancerListenersDescriptionCopier.copy(listeners);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listeners(Listener ... listeners) {
            this.listeners(Arrays.asList(listeners));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listeners(Consumer<Listener.Builder> ... listeners) {
            this.listeners(Stream.of(listeners).map(c -> (Listener)((Listener.Builder)Listener.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setListeners(Collection<Listener.BuilderImpl> listeners) {
            this.listeners = LoadBalancerListenersDescriptionCopier.copyFromBuilder(listeners);
        }

        public LoadBalancerDescription build() {
            return new LoadBalancerDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LoadBalancerDescription> {
        public Builder loadBalancerName(String var1);

        public Builder domain(String var1);

        public Builder listeners(Collection<Listener> var1);

        public Builder listeners(Listener ... var1);

        public Builder listeners(Consumer<Listener.Builder> ... var1);
    }
}

