/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentIdListCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentNamesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeEnvironmentsRequest
extends ElasticBeanstalkRequest
implements ToCopyableBuilder<Builder, DescribeEnvironmentsRequest> {
    private final String applicationName;
    private final String versionLabel;
    private final List<String> environmentIds;
    private final List<String> environmentNames;
    private final Boolean includeDeleted;
    private final Instant includedDeletedBackTo;
    private final Integer maxRecords;
    private final String nextToken;

    private DescribeEnvironmentsRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.versionLabel = builder.versionLabel;
        this.environmentIds = builder.environmentIds;
        this.environmentNames = builder.environmentNames;
        this.includeDeleted = builder.includeDeleted;
        this.includedDeletedBackTo = builder.includedDeletedBackTo;
        this.maxRecords = builder.maxRecords;
        this.nextToken = builder.nextToken;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String versionLabel() {
        return this.versionLabel;
    }

    public List<String> environmentIds() {
        return this.environmentIds;
    }

    public List<String> environmentNames() {
        return this.environmentNames;
    }

    public Boolean includeDeleted() {
        return this.includeDeleted;
    }

    public Instant includedDeletedBackTo() {
        return this.includedDeletedBackTo;
    }

    public Integer maxRecords() {
        return this.maxRecords;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeDeleted());
        hashCode = 31 * hashCode + Objects.hashCode(this.includedDeletedBackTo());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEnvironmentsRequest)) {
            return false;
        }
        DescribeEnvironmentsRequest other = (DescribeEnvironmentsRequest)((Object)obj);
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.versionLabel(), other.versionLabel()) && Objects.equals(this.environmentIds(), other.environmentIds()) && Objects.equals(this.environmentNames(), other.environmentNames()) && Objects.equals(this.includeDeleted(), other.includeDeleted()) && Objects.equals(this.includedDeletedBackTo(), other.includedDeletedBackTo()) && Objects.equals(this.maxRecords(), other.maxRecords()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeEnvironmentsRequest").add("ApplicationName", (Object)this.applicationName()).add("VersionLabel", (Object)this.versionLabel()).add("EnvironmentIds", this.environmentIds()).add("EnvironmentNames", this.environmentNames()).add("IncludeDeleted", (Object)this.includeDeleted()).add("IncludedDeletedBackTo", (Object)this.includedDeletedBackTo()).add("MaxRecords", (Object)this.maxRecords()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationName": {
                return Optional.of(clazz.cast(this.applicationName()));
            }
            case "VersionLabel": {
                return Optional.of(clazz.cast(this.versionLabel()));
            }
            case "EnvironmentIds": {
                return Optional.of(clazz.cast(this.environmentIds()));
            }
            case "EnvironmentNames": {
                return Optional.of(clazz.cast(this.environmentNames()));
            }
            case "IncludeDeleted": {
                return Optional.of(clazz.cast(this.includeDeleted()));
            }
            case "IncludedDeletedBackTo": {
                return Optional.of(clazz.cast(this.includedDeletedBackTo()));
            }
            case "MaxRecords": {
                return Optional.of(clazz.cast(this.maxRecords()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticBeanstalkRequest.BuilderImpl
    implements Builder {
        private String applicationName;
        private String versionLabel;
        private List<String> environmentIds;
        private List<String> environmentNames;
        private Boolean includeDeleted;
        private Instant includedDeletedBackTo;
        private Integer maxRecords;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEnvironmentsRequest model) {
            super(model);
            this.applicationName(model.applicationName);
            this.versionLabel(model.versionLabel);
            this.environmentIds(model.environmentIds);
            this.environmentNames(model.environmentNames);
            this.includeDeleted(model.includeDeleted);
            this.includedDeletedBackTo(model.includedDeletedBackTo);
            this.maxRecords(model.maxRecords);
            this.nextToken(model.nextToken);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getVersionLabel() {
            return this.versionLabel;
        }

        @Override
        public final Builder versionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
            return this;
        }

        public final void setVersionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
        }

        public final Collection<String> getEnvironmentIds() {
            return this.environmentIds;
        }

        @Override
        public final Builder environmentIds(Collection<String> environmentIds) {
            this.environmentIds = EnvironmentIdListCopier.copy(environmentIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentIds(String ... environmentIds) {
            this.environmentIds(Arrays.asList(environmentIds));
            return this;
        }

        public final void setEnvironmentIds(Collection<String> environmentIds) {
            this.environmentIds = EnvironmentIdListCopier.copy(environmentIds);
        }

        public final Collection<String> getEnvironmentNames() {
            return this.environmentNames;
        }

        @Override
        public final Builder environmentNames(Collection<String> environmentNames) {
            this.environmentNames = EnvironmentNamesListCopier.copy(environmentNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentNames(String ... environmentNames) {
            this.environmentNames(Arrays.asList(environmentNames));
            return this;
        }

        public final void setEnvironmentNames(Collection<String> environmentNames) {
            this.environmentNames = EnvironmentNamesListCopier.copy(environmentNames);
        }

        public final Boolean getIncludeDeleted() {
            return this.includeDeleted;
        }

        @Override
        public final Builder includeDeleted(Boolean includeDeleted) {
            this.includeDeleted = includeDeleted;
            return this;
        }

        public final void setIncludeDeleted(Boolean includeDeleted) {
            this.includeDeleted = includeDeleted;
        }

        public final Instant getIncludedDeletedBackTo() {
            return this.includedDeletedBackTo;
        }

        @Override
        public final Builder includedDeletedBackTo(Instant includedDeletedBackTo) {
            this.includedDeletedBackTo = includedDeletedBackTo;
            return this;
        }

        public final void setIncludedDeletedBackTo(Instant includedDeletedBackTo) {
            this.includedDeletedBackTo = includedDeletedBackTo;
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeEnvironmentsRequest build() {
            return new DescribeEnvironmentsRequest(this);
        }
    }

    public static interface Builder
    extends ElasticBeanstalkRequest.Builder,
    CopyableBuilder<Builder, DescribeEnvironmentsRequest> {
        public Builder applicationName(String var1);

        public Builder versionLabel(String var1);

        public Builder environmentIds(Collection<String> var1);

        public Builder environmentIds(String ... var1);

        public Builder environmentNames(Collection<String> var1);

        public Builder environmentNames(String ... var1);

        public Builder includeDeleted(Boolean var1);

        public Builder includedDeletedBackTo(Instant var1);

        public Builder maxRecords(Integer var1);

        public Builder nextToken(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

