/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Deployment
implements ToCopyableBuilder<Builder, Deployment> {
    private final String versionLabel;
    private final Long deploymentId;
    private final String status;
    private final Instant deploymentTime;

    private Deployment(BuilderImpl builder) {
        this.versionLabel = builder.versionLabel;
        this.deploymentId = builder.deploymentId;
        this.status = builder.status;
        this.deploymentTime = builder.deploymentTime;
    }

    public String versionLabel() {
        return this.versionLabel;
    }

    public Long deploymentId() {
        return this.deploymentId;
    }

    public String status() {
        return this.status;
    }

    public Instant deploymentTime() {
        return this.deploymentTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.versionLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Deployment)) {
            return false;
        }
        Deployment other = (Deployment)obj;
        return Objects.equals(this.versionLabel(), other.versionLabel()) && Objects.equals(this.deploymentId(), other.deploymentId()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.deploymentTime(), other.deploymentTime());
    }

    public String toString() {
        return ToString.builder((String)"Deployment").add("VersionLabel", (Object)this.versionLabel()).add("DeploymentId", (Object)this.deploymentId()).add("Status", (Object)this.status()).add("DeploymentTime", (Object)this.deploymentTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VersionLabel": {
                return Optional.of(clazz.cast(this.versionLabel()));
            }
            case "DeploymentId": {
                return Optional.of(clazz.cast(this.deploymentId()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.status()));
            }
            case "DeploymentTime": {
                return Optional.of(clazz.cast(this.deploymentTime()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String versionLabel;
        private Long deploymentId;
        private String status;
        private Instant deploymentTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Deployment model) {
            this.versionLabel(model.versionLabel);
            this.deploymentId(model.deploymentId);
            this.status(model.status);
            this.deploymentTime(model.deploymentTime);
        }

        public final String getVersionLabel() {
            return this.versionLabel;
        }

        @Override
        public final Builder versionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
            return this;
        }

        public final void setVersionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
        }

        public final Long getDeploymentId() {
            return this.deploymentId;
        }

        @Override
        public final Builder deploymentId(Long deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(Long deploymentId) {
            this.deploymentId = deploymentId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getDeploymentTime() {
            return this.deploymentTime;
        }

        @Override
        public final Builder deploymentTime(Instant deploymentTime) {
            this.deploymentTime = deploymentTime;
            return this;
        }

        public final void setDeploymentTime(Instant deploymentTime) {
            this.deploymentTime = deploymentTime;
        }

        public Deployment build() {
            return new Deployment(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Deployment> {
        public Builder versionLabel(String var1);

        public Builder deploymentId(Long var1);

        public Builder status(String var1);

        public Builder deploymentTime(Instant var1);
    }
}

