/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CheckDNSAvailabilityRequest
extends ElasticBeanstalkRequest
implements ToCopyableBuilder<Builder, CheckDNSAvailabilityRequest> {
    private final String cnamePrefix;

    private CheckDNSAvailabilityRequest(BuilderImpl builder) {
        super(builder);
        this.cnamePrefix = builder.cnamePrefix;
    }

    public String cnamePrefix() {
        return this.cnamePrefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cnamePrefix());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckDNSAvailabilityRequest)) {
            return false;
        }
        CheckDNSAvailabilityRequest other = (CheckDNSAvailabilityRequest)((Object)obj);
        return Objects.equals(this.cnamePrefix(), other.cnamePrefix());
    }

    public String toString() {
        return ToString.builder((String)"CheckDNSAvailabilityRequest").add("CNAMEPrefix", (Object)this.cnamePrefix()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CNAMEPrefix": {
                return Optional.of(clazz.cast(this.cnamePrefix()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticBeanstalkRequest.BuilderImpl
    implements Builder {
        private String cnamePrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(CheckDNSAvailabilityRequest model) {
            super(model);
            this.cnamePrefix(model.cnamePrefix);
        }

        public final String getCNAMEPrefix() {
            return this.cnamePrefix;
        }

        @Override
        public final Builder cnamePrefix(String cnamePrefix) {
            this.cnamePrefix = cnamePrefix;
            return this;
        }

        public final void setCNAMEPrefix(String cnamePrefix) {
            this.cnamePrefix = cnamePrefix;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CheckDNSAvailabilityRequest build() {
            return new CheckDNSAvailabilityRequest(this);
        }
    }

    public static interface Builder
    extends ElasticBeanstalkRequest.Builder,
    CopyableBuilder<Builder, CheckDNSAvailabilityRequest> {
        public Builder cnamePrefix(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

